<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adjuntarDocumentoRespuesta StructType
 * Meta information extracted from the WSDL
 * - documentation: Respuesta de la operacion de adjuntar documentacion. true cuando a pesar de que expediente no existe o esta terminado, el documento se adjunta. false si el documento se ha insertado correctamente, y el expediente al que se le ha
 * insertado estaba registrado en sanciones.
 * @subpackage Structs
 */
class AdjuntarDocumentoRespuesta extends AbstractStructBase
{
    /**
     * The expedienteInexistente
     * Meta information extracted from the WSDL
     * - documentation: Indicativo de si el expediente no existia y se ha forzado la insercion del documento
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $expedienteInexistente;
    /**
     * Constructor method for adjuntarDocumentoRespuesta
     * @uses AdjuntarDocumentoRespuesta::setExpedienteInexistente()
     * @param bool $expedienteInexistente
     */
    public function __construct($expedienteInexistente = null)
    {
        $this
            ->setExpedienteInexistente($expedienteInexistente);
    }
    /**
     * Get expedienteInexistente value
     * @return bool
     */
    public function getExpedienteInexistente()
    {
        return $this->expedienteInexistente;
    }
    /**
     * Set expedienteInexistente value
     * @param bool $expedienteInexistente
     * @return \StructType\AdjuntarDocumentoRespuesta
     */
    public function setExpedienteInexistente($expedienteInexistente = null)
    {
        // validation for constraint: boolean
        if (!is_null($expedienteInexistente) && !is_bool($expedienteInexistente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expedienteInexistente, true), gettype($expedienteInexistente)), __LINE__);
        }
        $this->expedienteInexistente = $expedienteInexistente;
        return $this;
    }
}
