<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehiculo StructType
 * @subpackage Structs
 */
class Vehiculo extends AbstractStructBase
{
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - documentation: Matricula del vehiculo denunciado.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Matricula
     */
    public $matricula;
    /**
     * The color
     * Meta information extracted from the WSDL
     * - documentation: Color del vehiculo.EJ: Azul
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $color;
    /**
     * The marca
     * Meta information extracted from the WSDL
     * - documentation: Marca del vehiculo. Ej: SUZUKI
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $marca;
    /**
     * The modelo
     * Meta information extracted from the WSDL
     * - documentation: Modelo del vehiculo. EJ: VITARA
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $modelo;
    /**
     * The tipoVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tipoVehiculo;
    /**
     * Constructor method for Vehiculo
     * @uses Vehiculo::setMatricula()
     * @uses Vehiculo::setColor()
     * @uses Vehiculo::setMarca()
     * @uses Vehiculo::setModelo()
     * @uses Vehiculo::setTipoVehiculo()
     * @param \StructType\Matricula $matricula
     * @param string $color
     * @param string $marca
     * @param string $modelo
     * @param string $tipoVehiculo
     */
    public function __construct(\StructType\Matricula $matricula = null, $color = null, $marca = null, $modelo = null, $tipoVehiculo = null)
    {
        $this
            ->setMatricula($matricula)
            ->setColor($color)
            ->setMarca($marca)
            ->setModelo($modelo)
            ->setTipoVehiculo($tipoVehiculo);
    }
    /**
     * Get matricula value
     * @return \StructType\Matricula
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param \StructType\Matricula $matricula
     * @return \StructType\Vehiculo
     */
    public function setMatricula(\StructType\Matricula $matricula = null)
    {
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param string $color
     * @return \StructType\Vehiculo
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get marca value
     * @return string|null
     */
    public function getMarca()
    {
        return $this->marca;
    }
    /**
     * Set marca value
     * @param string $marca
     * @return \StructType\Vehiculo
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marca, true), gettype($marca)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($marca) && mb_strlen($marca) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($marca)), __LINE__);
        }
        $this->marca = $marca;
        return $this;
    }
    /**
     * Get modelo value
     * @return string|null
     */
    public function getModelo()
    {
        return $this->modelo;
    }
    /**
     * Set modelo value
     * @param string $modelo
     * @return \StructType\Vehiculo
     */
    public function setModelo($modelo = null)
    {
        // validation for constraint: string
        if (!is_null($modelo) && !is_string($modelo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelo, true), gettype($modelo)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($modelo) && mb_strlen($modelo) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($modelo)), __LINE__);
        }
        $this->modelo = $modelo;
        return $this;
    }
    /**
     * Get tipoVehiculo value
     * @return string|null
     */
    public function getTipoVehiculo()
    {
        return $this->tipoVehiculo;
    }
    /**
     * Set tipoVehiculo value
     * @uses \EnumType\TipoVehiculo::valueIsValid()
     * @uses \EnumType\TipoVehiculo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoVehiculo
     * @return \StructType\Vehiculo
     */
    public function setTipoVehiculo($tipoVehiculo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoVehiculo::valueIsValid($tipoVehiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoVehiculo', is_array($tipoVehiculo) ? implode(', ', $tipoVehiculo) : var_export($tipoVehiculo, true), implode(', ', \EnumType\TipoVehiculo::getValidValues())), __LINE__);
        }
        $this->tipoVehiculo = $tipoVehiculo;
        return $this;
    }
}
