<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreceptoInfringido StructType
 * Meta information extracted from the WSDL
 * - documentation: Precepto que se ha infringido en el expediente.
 * @subpackage Structs
 */
class PreceptoInfringido extends AbstractStructBase
{
    /**
     * The codigoPrecepto
     * Meta information extracted from the WSDL
     * - documentation: Codificacion del precepto infringido
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CodigoPrecepto
     */
    public $codigoPrecepto;
    /**
     * The hechoDenunciado
     * Meta information extracted from the WSDL
     * - documentation: Hecho denunciado, catalogacion del precepto infringido
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HechoDenunciado
     */
    public $hechoDenunciado;
    /**
     * Constructor method for PreceptoInfringido
     * @uses PreceptoInfringido::setCodigoPrecepto()
     * @uses PreceptoInfringido::setHechoDenunciado()
     * @param \StructType\CodigoPrecepto $codigoPrecepto
     * @param \StructType\HechoDenunciado $hechoDenunciado
     */
    public function __construct(\StructType\CodigoPrecepto $codigoPrecepto = null, \StructType\HechoDenunciado $hechoDenunciado = null)
    {
        $this
            ->setCodigoPrecepto($codigoPrecepto)
            ->setHechoDenunciado($hechoDenunciado);
    }
    /**
     * Get codigoPrecepto value
     * @return \StructType\CodigoPrecepto
     */
    public function getCodigoPrecepto()
    {
        return $this->codigoPrecepto;
    }
    /**
     * Set codigoPrecepto value
     * @param \StructType\CodigoPrecepto $codigoPrecepto
     * @return \StructType\PreceptoInfringido
     */
    public function setCodigoPrecepto(\StructType\CodigoPrecepto $codigoPrecepto = null)
    {
        $this->codigoPrecepto = $codigoPrecepto;
        return $this;
    }
    /**
     * Get hechoDenunciado value
     * @return \StructType\HechoDenunciado
     */
    public function getHechoDenunciado()
    {
        return $this->hechoDenunciado;
    }
    /**
     * Set hechoDenunciado value
     * @param \StructType\HechoDenunciado $hechoDenunciado
     * @return \StructType\PreceptoInfringido
     */
    public function setHechoDenunciado(\StructType\HechoDenunciado $hechoDenunciado = null)
    {
        $this->hechoDenunciado = $hechoDenunciado;
        return $this;
    }
}
