<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtroDenunciado StructType
 * @subpackage Structs
 */
class OtroDenunciado extends AbstractStructBase
{
    /**
     * The descripcionOtroObjetoDenunciado
     * Meta information extracted from the WSDL
     * - documentation: Descripcion del objeto denunciado. Por ejemplo marca de un ciclo.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descripcionOtroObjetoDenunciado;
    /**
     * The otroObjetoDenunciado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $otroObjetoDenunciado;
    /**
     * Constructor method for OtroDenunciado
     * @uses OtroDenunciado::setDescripcionOtroObjetoDenunciado()
     * @uses OtroDenunciado::setOtroObjetoDenunciado()
     * @param string $descripcionOtroObjetoDenunciado
     * @param string $otroObjetoDenunciado
     */
    public function __construct($descripcionOtroObjetoDenunciado = null, $otroObjetoDenunciado = null)
    {
        $this
            ->setDescripcionOtroObjetoDenunciado($descripcionOtroObjetoDenunciado)
            ->setOtroObjetoDenunciado($otroObjetoDenunciado);
    }
    /**
     * Get descripcionOtroObjetoDenunciado value
     * @return string|null
     */
    public function getDescripcionOtroObjetoDenunciado()
    {
        return $this->descripcionOtroObjetoDenunciado;
    }
    /**
     * Set descripcionOtroObjetoDenunciado value
     * @param string $descripcionOtroObjetoDenunciado
     * @return \StructType\OtroDenunciado
     */
    public function setDescripcionOtroObjetoDenunciado($descripcionOtroObjetoDenunciado = null)
    {
        // validation for constraint: string
        if (!is_null($descripcionOtroObjetoDenunciado) && !is_string($descripcionOtroObjetoDenunciado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcionOtroObjetoDenunciado, true), gettype($descripcionOtroObjetoDenunciado)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($descripcionOtroObjetoDenunciado) && mb_strlen($descripcionOtroObjetoDenunciado) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($descripcionOtroObjetoDenunciado)), __LINE__);
        }
        $this->descripcionOtroObjetoDenunciado = $descripcionOtroObjetoDenunciado;
        return $this;
    }
    /**
     * Get otroObjetoDenunciado value
     * @return string|null
     */
    public function getOtroObjetoDenunciado()
    {
        return $this->otroObjetoDenunciado;
    }
    /**
     * Set otroObjetoDenunciado value
     * @uses \EnumType\OtroObjetoDenunciado::valueIsValid()
     * @uses \EnumType\OtroObjetoDenunciado::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $otroObjetoDenunciado
     * @return \StructType\OtroDenunciado
     */
    public function setOtroObjetoDenunciado($otroObjetoDenunciado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OtroObjetoDenunciado::valueIsValid($otroObjetoDenunciado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OtroObjetoDenunciado', is_array($otroObjetoDenunciado) ? implode(', ', $otroObjetoDenunciado) : var_export($otroObjetoDenunciado, true), implode(', ', \EnumType\OtroObjetoDenunciado::getValidValues())), __LINE__);
        }
        $this->otroObjetoDenunciado = $otroObjetoDenunciado;
        return $this;
    }
}
