<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Oficio StructType
 * @subpackage Structs
 */
class Oficio extends AbstractStructBase
{
    /**
     * The idJefatura
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la jefatura instructora del expediente.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idJefatura;
    /**
     * The fechaHoraDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora del expediente.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FechaHora
     */
    public $fechaHoraDenuncia;
    /**
     * The lugarDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Lugar en el que se interpone la denuncia.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LugarDenuncia
     */
    public $lugarDenuncia;
    /**
     * The tipoOficio
     * Meta information extracted from the WSDL
     * - documentation: Tipo de oficio, que indica el motivo por el que se crea la denuncia. Los posibles valores se corresponden con el campo ETIQUETA_DENU de la tabla TIPOS_DENUNCIAS_OFICIO.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipoOficio;
    /**
     * The matricula
     * Meta information extracted from the WSDL
     * - documentation: Matricula del vehiculo denunciado en la sancion. Debera indicarse obligatoriamente una matricula para el vehiculo denunciado en la sancion. Ej: 1010GGG
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $matricula;
    /**
     * The idVideo
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la cámara. Normalmente se tratara de un cinemómetro TEV. Ej: TEV001124
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idVideo;
    /**
     * The documentacionOficio
     * Meta information extracted from the WSDL
     * - documentation: Coleccion de imagenes que puede tener la infraccion de cinturon de seguridad
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentacionOficio[]
     */
    public $documentacionOficio;
    /**
     * Constructor method for Oficio
     * @uses Oficio::setIdJefatura()
     * @uses Oficio::setFechaHoraDenuncia()
     * @uses Oficio::setLugarDenuncia()
     * @uses Oficio::setTipoOficio()
     * @uses Oficio::setMatricula()
     * @uses Oficio::setIdVideo()
     * @uses Oficio::setDocumentacionOficio()
     * @param string $idJefatura
     * @param \StructType\FechaHora $fechaHoraDenuncia
     * @param \StructType\LugarDenuncia $lugarDenuncia
     * @param string $tipoOficio
     * @param string $matricula
     * @param string $idVideo
     * @param \StructType\DocumentacionOficio[] $documentacionOficio
     */
    public function __construct($idJefatura = null, \StructType\FechaHora $fechaHoraDenuncia = null, \StructType\LugarDenuncia $lugarDenuncia = null, $tipoOficio = null, $matricula = null, $idVideo = null, array $documentacionOficio = array())
    {
        $this
            ->setIdJefatura($idJefatura)
            ->setFechaHoraDenuncia($fechaHoraDenuncia)
            ->setLugarDenuncia($lugarDenuncia)
            ->setTipoOficio($tipoOficio)
            ->setMatricula($matricula)
            ->setIdVideo($idVideo)
            ->setDocumentacionOficio($documentacionOficio);
    }
    /**
     * Get idJefatura value
     * @return string
     */
    public function getIdJefatura()
    {
        return $this->idJefatura;
    }
    /**
     * Set idJefatura value
     * @uses \EnumType\Jefatura::valueIsValid()
     * @uses \EnumType\Jefatura::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idJefatura
     * @return \StructType\Oficio
     */
    public function setIdJefatura($idJefatura = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Jefatura::valueIsValid($idJefatura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Jefatura', is_array($idJefatura) ? implode(', ', $idJefatura) : var_export($idJefatura, true), implode(', ', \EnumType\Jefatura::getValidValues())), __LINE__);
        }
        $this->idJefatura = $idJefatura;
        return $this;
    }
    /**
     * Get fechaHoraDenuncia value
     * @return \StructType\FechaHora
     */
    public function getFechaHoraDenuncia()
    {
        return $this->fechaHoraDenuncia;
    }
    /**
     * Set fechaHoraDenuncia value
     * @param \StructType\FechaHora $fechaHoraDenuncia
     * @return \StructType\Oficio
     */
    public function setFechaHoraDenuncia(\StructType\FechaHora $fechaHoraDenuncia = null)
    {
        $this->fechaHoraDenuncia = $fechaHoraDenuncia;
        return $this;
    }
    /**
     * Get lugarDenuncia value
     * @return \StructType\LugarDenuncia
     */
    public function getLugarDenuncia()
    {
        return $this->lugarDenuncia;
    }
    /**
     * Set lugarDenuncia value
     * @param \StructType\LugarDenuncia $lugarDenuncia
     * @return \StructType\Oficio
     */
    public function setLugarDenuncia(\StructType\LugarDenuncia $lugarDenuncia = null)
    {
        $this->lugarDenuncia = $lugarDenuncia;
        return $this;
    }
    /**
     * Get tipoOficio value
     * @return string
     */
    public function getTipoOficio()
    {
        return $this->tipoOficio;
    }
    /**
     * Set tipoOficio value
     * @param string $tipoOficio
     * @return \StructType\Oficio
     */
    public function setTipoOficio($tipoOficio = null)
    {
        // validation for constraint: string
        if (!is_null($tipoOficio) && !is_string($tipoOficio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoOficio, true), gettype($tipoOficio)), __LINE__);
        }
        $this->tipoOficio = $tipoOficio;
        return $this;
    }
    /**
     * Get matricula value
     * @return string
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
    /**
     * Set matricula value
     * @param string $matricula
     * @return \StructType\Oficio
     */
    public function setMatricula($matricula = null)
    {
        // validation for constraint: string
        if (!is_null($matricula) && !is_string($matricula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matricula, true), gettype($matricula)), __LINE__);
        }
        $this->matricula = $matricula;
        return $this;
    }
    /**
     * Get idVideo value
     * @return string|null
     */
    public function getIdVideo()
    {
        return $this->idVideo;
    }
    /**
     * Set idVideo value
     * @param string $idVideo
     * @return \StructType\Oficio
     */
    public function setIdVideo($idVideo = null)
    {
        // validation for constraint: string
        if (!is_null($idVideo) && !is_string($idVideo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idVideo, true), gettype($idVideo)), __LINE__);
        }
        $this->idVideo = $idVideo;
        return $this;
    }
    /**
     * Get documentacionOficio value
     * @return \StructType\DocumentacionOficio[]|null
     */
    public function getDocumentacionOficio()
    {
        return $this->documentacionOficio;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentacionOficio method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentacionOficio method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentacionOficioForArrayConstraintsFromSetDocumentacionOficio(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oficioDocumentacionOficioItem) {
            // validation for constraint: itemType
            if (!$oficioDocumentacionOficioItem instanceof \StructType\DocumentacionOficio) {
                $invalidValues[] = is_object($oficioDocumentacionOficioItem) ? get_class($oficioDocumentacionOficioItem) : sprintf('%s(%s)', gettype($oficioDocumentacionOficioItem), var_export($oficioDocumentacionOficioItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documentacionOficio property can only contain items of type \StructType\DocumentacionOficio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documentacionOficio value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentacionOficio[] $documentacionOficio
     * @return \StructType\Oficio
     */
    public function setDocumentacionOficio(array $documentacionOficio = array())
    {
        // validation for constraint: array
        if ('' !== ($documentacionOficioArrayErrorMessage = self::validateDocumentacionOficioForArrayConstraintsFromSetDocumentacionOficio($documentacionOficio))) {
            throw new \InvalidArgumentException($documentacionOficioArrayErrorMessage, __LINE__);
        }
        $this->documentacionOficio = $documentacionOficio;
        return $this;
    }
    /**
     * Add item to documentacionOficio value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentacionOficio $item
     * @return \StructType\Oficio
     */
    public function addToDocumentacionOficio(\StructType\DocumentacionOficio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentacionOficio) {
            throw new \InvalidArgumentException(sprintf('The documentacionOficio property can only contain items of type \StructType\DocumentacionOficio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documentacionOficio[] = $item;
        return $this;
    }
}
