<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjetoDenunciado StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacion del objeto denunciado: vehiculo o no vehiculo
 * @subpackage Structs
 */
class ObjetoDenunciado extends AbstractStructBase
{
    /**
     * The vehiculo
     * Meta information extracted from the WSDL
     * - documentation: Objeto denunciado de tipo vehiculo.
     * - choice: vehiculo | centro | escuela | otroDenunciado
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Vehiculo
     */
    public $vehiculo;
    /**
     * The centro
     * Meta information extracted from the WSDL
     * - documentation: Objeto denunciado de tipo centro de reconocimiento.
     * - choice: vehiculo | centro | escuela | otroDenunciado
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CentroReconocimiento
     */
    public $centro;
    /**
     * The escuela
     * Meta information extracted from the WSDL
     * - documentation: Objeto denunciado de tipo escuela.
     * - choice: vehiculo | centro | escuela | otroDenunciado
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Escuela
     */
    public $escuela;
    /**
     * The otroDenunciado
     * Meta information extracted from the WSDL
     * - documentation: Indica que el objeto denunciado no es un centro de reconocimiento, escuela o vehiculo, por ejemplo un no vehiculo. Ej: PEATON
     * - choice: vehiculo | centro | escuela | otroDenunciado
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OtroDenunciado
     */
    public $otroDenunciado;
    /**
     * Constructor method for ObjetoDenunciado
     * @uses ObjetoDenunciado::setVehiculo()
     * @uses ObjetoDenunciado::setCentro()
     * @uses ObjetoDenunciado::setEscuela()
     * @uses ObjetoDenunciado::setOtroDenunciado()
     * @param \StructType\Vehiculo $vehiculo
     * @param \StructType\CentroReconocimiento $centro
     * @param \StructType\Escuela $escuela
     * @param \StructType\OtroDenunciado $otroDenunciado
     */
    public function __construct(\StructType\Vehiculo $vehiculo = null, \StructType\CentroReconocimiento $centro = null, \StructType\Escuela $escuela = null, \StructType\OtroDenunciado $otroDenunciado = null)
    {
        $this
            ->setVehiculo($vehiculo)
            ->setCentro($centro)
            ->setEscuela($escuela)
            ->setOtroDenunciado($otroDenunciado);
    }
    /**
     * Get vehiculo value
     * @return \StructType\Vehiculo|null
     */
    public function getVehiculo()
    {
        return isset($this->vehiculo) ? $this->vehiculo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVehiculo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehiculo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVehiculoForChoiceConstraintsFromSetVehiculo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'centro',
            'escuela',
            'otroDenunciado',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property vehiculo can\'t be set as the property %s is already set. Only one property must be set among these properties: vehiculo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set vehiculo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Vehiculo $vehiculo
     * @return \StructType\ObjetoDenunciado
     */
    public function setVehiculo(\StructType\Vehiculo $vehiculo = null)
    {
        // validation for constraint: choice(vehiculo, centro, escuela, otroDenunciado)
        if ('' !== ($vehiculoChoiceErrorMessage = self::validateVehiculoForChoiceConstraintsFromSetVehiculo($vehiculo))) {
            throw new \InvalidArgumentException($vehiculoChoiceErrorMessage, __LINE__);
        }
        if (is_null($vehiculo) || (is_array($vehiculo) && empty($vehiculo))) {
            unset($this->vehiculo);
        } else {
            $this->vehiculo = $vehiculo;
        }
        return $this;
    }
    /**
     * Get centro value
     * @return \StructType\CentroReconocimiento|null
     */
    public function getCentro()
    {
        return isset($this->centro) ? $this->centro : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCentro method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCentro method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCentroForChoiceConstraintsFromSetCentro($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'vehiculo',
            'escuela',
            'otroDenunciado',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property centro can\'t be set as the property %s is already set. Only one property must be set among these properties: centro, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set centro value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CentroReconocimiento $centro
     * @return \StructType\ObjetoDenunciado
     */
    public function setCentro(\StructType\CentroReconocimiento $centro = null)
    {
        // validation for constraint: choice(vehiculo, centro, escuela, otroDenunciado)
        if ('' !== ($centroChoiceErrorMessage = self::validateCentroForChoiceConstraintsFromSetCentro($centro))) {
            throw new \InvalidArgumentException($centroChoiceErrorMessage, __LINE__);
        }
        if (is_null($centro) || (is_array($centro) && empty($centro))) {
            unset($this->centro);
        } else {
            $this->centro = $centro;
        }
        return $this;
    }
    /**
     * Get escuela value
     * @return \StructType\Escuela|null
     */
    public function getEscuela()
    {
        return isset($this->escuela) ? $this->escuela : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEscuela method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEscuela method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEscuelaForChoiceConstraintsFromSetEscuela($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'vehiculo',
            'centro',
            'otroDenunciado',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property escuela can\'t be set as the property %s is already set. Only one property must be set among these properties: escuela, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set escuela value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Escuela $escuela
     * @return \StructType\ObjetoDenunciado
     */
    public function setEscuela(\StructType\Escuela $escuela = null)
    {
        // validation for constraint: choice(vehiculo, centro, escuela, otroDenunciado)
        if ('' !== ($escuelaChoiceErrorMessage = self::validateEscuelaForChoiceConstraintsFromSetEscuela($escuela))) {
            throw new \InvalidArgumentException($escuelaChoiceErrorMessage, __LINE__);
        }
        if (is_null($escuela) || (is_array($escuela) && empty($escuela))) {
            unset($this->escuela);
        } else {
            $this->escuela = $escuela;
        }
        return $this;
    }
    /**
     * Get otroDenunciado value
     * @return \StructType\OtroDenunciado|null
     */
    public function getOtroDenunciado()
    {
        return isset($this->otroDenunciado) ? $this->otroDenunciado : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOtroDenunciado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtroDenunciado method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOtroDenunciadoForChoiceConstraintsFromSetOtroDenunciado($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'vehiculo',
            'centro',
            'escuela',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property otroDenunciado can\'t be set as the property %s is already set. Only one property must be set among these properties: otroDenunciado, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set otroDenunciado value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OtroDenunciado $otroDenunciado
     * @return \StructType\ObjetoDenunciado
     */
    public function setOtroDenunciado(\StructType\OtroDenunciado $otroDenunciado = null)
    {
        // validation for constraint: choice(vehiculo, centro, escuela, otroDenunciado)
        if ('' !== ($otroDenunciadoChoiceErrorMessage = self::validateOtroDenunciadoForChoiceConstraintsFromSetOtroDenunciado($otroDenunciado))) {
            throw new \InvalidArgumentException($otroDenunciadoChoiceErrorMessage, __LINE__);
        }
        if (is_null($otroDenunciado) || (is_array($otroDenunciado) && empty($otroDenunciado))) {
            unset($this->otroDenunciado);
        } else {
            $this->otroDenunciado = $otroDenunciado;
        }
        return $this;
    }
}
