<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LugarDenunciaInterurbana StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacion de un lugar interubano en el que se produce una infraccion
 * @subpackage Structs
 */
class LugarDenunciaInterurbana extends AbstractStructBase
{
    /**
     * The carretera
     * Meta information extracted from the WSDL
     * - documentation: Carrera de la via interurbana en la que se pone la denuncia. La carretera debera informar la sigla y la via separadas por el delimitador ‘-‘ o un espacio blanco. La longitud de sigla no debera superar las 2 posiciones y la del
     * numero o identificador las 4 posiciones. Ej: A-6
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carretera;
    /**
     * The direccionCarretera
     * Meta information extracted from the WSDL
     * - documentation: Sentido de la via interurbana en la que se pone la denuncia. Ej: D-DECRECIENTE
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $direccionCarretera;
    /**
     * The pk
     * Meta information extracted from the WSDL
     * - documentation: Punto kilometrico de la via interurbana en la que se pone la denuncia. Su valor debe ser numerico decimal (dddd.d) y debera tener un valor para indicar kilometro que no supere las 4 cifras y la parte decimal indicara el hectometro no
     * debiendo superar las unidades. Ej. 200.1
     * - base: xsd:double
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{1,4}(\.\d+)?
     * @var float
     */
    public $pk;
    /**
     * The carril
     * Meta information extracted from the WSDL
     * - documentation: Identificador del carril
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carril;
    /**
     * Constructor method for LugarDenunciaInterurbana
     * @uses LugarDenunciaInterurbana::setCarretera()
     * @uses LugarDenunciaInterurbana::setDireccionCarretera()
     * @uses LugarDenunciaInterurbana::setPk()
     * @uses LugarDenunciaInterurbana::setCarril()
     * @param string $carretera
     * @param string $direccionCarretera
     * @param float $pk
     * @param string $carril
     */
    public function __construct($carretera = null, $direccionCarretera = null, $pk = null, $carril = null)
    {
        $this
            ->setCarretera($carretera)
            ->setDireccionCarretera($direccionCarretera)
            ->setPk($pk)
            ->setCarril($carril);
    }
    /**
     * Get carretera value
     * @return string
     */
    public function getCarretera()
    {
        return $this->carretera;
    }
    /**
     * Set carretera value
     * @param string $carretera
     * @return \StructType\LugarDenunciaInterurbana
     */
    public function setCarretera($carretera = null)
    {
        // validation for constraint: string
        if (!is_null($carretera) && !is_string($carretera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carretera, true), gettype($carretera)), __LINE__);
        }
        $this->carretera = $carretera;
        return $this;
    }
    /**
     * Get direccionCarretera value
     * @return string
     */
    public function getDireccionCarretera()
    {
        return $this->direccionCarretera;
    }
    /**
     * Set direccionCarretera value
     * @param string $direccionCarretera
     * @return \StructType\LugarDenunciaInterurbana
     */
    public function setDireccionCarretera($direccionCarretera = null)
    {
        // validation for constraint: string
        if (!is_null($direccionCarretera) && !is_string($direccionCarretera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccionCarretera, true), gettype($direccionCarretera)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($direccionCarretera) && mb_strlen($direccionCarretera) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($direccionCarretera)), __LINE__);
        }
        $this->direccionCarretera = $direccionCarretera;
        return $this;
    }
    /**
     * Get pk value
     * @return float
     */
    public function getPk()
    {
        return $this->pk;
    }
    /**
     * Set pk value
     * @param float $pk
     * @return \StructType\LugarDenunciaInterurbana
     */
    public function setPk($pk = null)
    {
        // validation for constraint: float
        if (!is_null($pk) && !(is_float($pk) || is_numeric($pk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pk, true), gettype($pk)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,4}(\.\d+)?)
        if (!is_null($pk) && !preg_match('/\\d{1,4}(\\.\\d+)?/', $pk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,4}(\.\d+)?', var_export($pk, true)), __LINE__);
        }
        $this->pk = $pk;
        return $this;
    }
    /**
     * Get carril value
     * @return string|null
     */
    public function getCarril()
    {
        return $this->carril;
    }
    /**
     * Set carril value
     * @param string $carril
     * @return \StructType\LugarDenunciaInterurbana
     */
    public function setCarril($carril = null)
    {
        // validation for constraint: string
        if (!is_null($carril) && !is_string($carril)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carril, true), gettype($carril)), __LINE__);
        }
        $this->carril = $carril;
        return $this;
    }
}
