<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Helicoptero StructType
 * @subpackage Structs
 */
class Helicoptero extends AbstractStructBase
{
    /**
     * The idHelicoptero
     * Meta information extracted from the WSDL
     * - documentation: Identificador del helicóptero. Por ej: 1413
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idHelicoptero;
    /**
     * The atgc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ATGC
     */
    public $atgc;
    /**
     * The operador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Operador
     */
    public $operador;
    /**
     * Constructor method for Helicoptero
     * @uses Helicoptero::setIdHelicoptero()
     * @uses Helicoptero::setAtgc()
     * @uses Helicoptero::setOperador()
     * @param string $idHelicoptero
     * @param \StructType\ATGC $atgc
     * @param \StructType\Operador $operador
     */
    public function __construct($idHelicoptero = null, \StructType\ATGC $atgc = null, \StructType\Operador $operador = null)
    {
        $this
            ->setIdHelicoptero($idHelicoptero)
            ->setAtgc($atgc)
            ->setOperador($operador);
    }
    /**
     * Get idHelicoptero value
     * @return string
     */
    public function getIdHelicoptero()
    {
        return $this->idHelicoptero;
    }
    /**
     * Set idHelicoptero value
     * @param string $idHelicoptero
     * @return \StructType\Helicoptero
     */
    public function setIdHelicoptero($idHelicoptero = null)
    {
        // validation for constraint: string
        if (!is_null($idHelicoptero) && !is_string($idHelicoptero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idHelicoptero, true), gettype($idHelicoptero)), __LINE__);
        }
        $this->idHelicoptero = $idHelicoptero;
        return $this;
    }
    /**
     * Get atgc value
     * @return \StructType\ATGC|null
     */
    public function getAtgc()
    {
        return $this->atgc;
    }
    /**
     * Set atgc value
     * @param \StructType\ATGC $atgc
     * @return \StructType\Helicoptero
     */
    public function setAtgc(\StructType\ATGC $atgc = null)
    {
        $this->atgc = $atgc;
        return $this;
    }
    /**
     * Get operador value
     * @return \StructType\Operador|null
     */
    public function getOperador()
    {
        return $this->operador;
    }
    /**
     * Set operador value
     * @param \StructType\Operador $operador
     * @return \StructType\Helicoptero
     */
    public function setOperador(\StructType\Operador $operador = null)
    {
        $this->operador = $operador;
        return $this;
    }
}
