<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcesoVelocidad StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacion sobre el exceso de velocidad de una infraccion
 * @subpackage Structs
 */
class ExcesoVelocidad extends AbstractStructBase
{
    /**
     * The tipoLimitacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipoLimitacion;
    /**
     * The velocidadLimitada
     * Meta information extracted from the WSDL
     * - documentation: Velocidad a la que estaba limitada la circulacion. Formato numerico, mayor que 1, menor que 340 y debera ser menor que la velocidad real.
     * - base: xsd:int
     * - maxInclusive: 340
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 1
     * @var int
     */
    public $velocidadLimitada;
    /**
     * The velocidadReal
     * Meta information extracted from the WSDL
     * - documentation: Velocidad a la que se detecto al infractor. Formato numerico, mayor que 1, menor que 340 y debera ser superior a la velocidad limitada.
     * - base: xsd:int
     * - maxInclusive: 340
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 1
     * @var int
     */
    public $velocidadReal;
    /**
     * The aparatoMedida
     * Meta information extracted from the WSDL
     * - documentation: Aparato con el que se registra el exceso de velocidad
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AparatoMedida
     */
    public $aparatoMedida;
    /**
     * The imagenFotoVelocidad
     * Meta information extracted from the WSDL
     * - documentation: Coleccion de imagenes que puede tener la infraccion de velocidad: foto portico, foto de fin de tramo, foto panoramica, etc. En caso de tratarse de una denuncia de portico sera obligatorio aportar la foto, no obstante se podra
     * realizar informando el elemento expediente.preceptoInfringido.hechoDenunciado.documentacion
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentoVelocidad[]
     */
    public $imagenFotoVelocidad;
    /**
     * Constructor method for ExcesoVelocidad
     * @uses ExcesoVelocidad::setTipoLimitacion()
     * @uses ExcesoVelocidad::setVelocidadLimitada()
     * @uses ExcesoVelocidad::setVelocidadReal()
     * @uses ExcesoVelocidad::setAparatoMedida()
     * @uses ExcesoVelocidad::setImagenFotoVelocidad()
     * @param string $tipoLimitacion
     * @param int $velocidadLimitada
     * @param int $velocidadReal
     * @param \StructType\AparatoMedida $aparatoMedida
     * @param \StructType\DocumentoVelocidad[] $imagenFotoVelocidad
     */
    public function __construct($tipoLimitacion = null, $velocidadLimitada = null, $velocidadReal = null, \StructType\AparatoMedida $aparatoMedida = null, array $imagenFotoVelocidad = array())
    {
        $this
            ->setTipoLimitacion($tipoLimitacion)
            ->setVelocidadLimitada($velocidadLimitada)
            ->setVelocidadReal($velocidadReal)
            ->setAparatoMedida($aparatoMedida)
            ->setImagenFotoVelocidad($imagenFotoVelocidad);
    }
    /**
     * Get tipoLimitacion value
     * @return string
     */
    public function getTipoLimitacion()
    {
        return $this->tipoLimitacion;
    }
    /**
     * Set tipoLimitacion value
     * @uses \EnumType\TipoLimitacion::valueIsValid()
     * @uses \EnumType\TipoLimitacion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoLimitacion
     * @return \StructType\ExcesoVelocidad
     */
    public function setTipoLimitacion($tipoLimitacion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoLimitacion::valueIsValid($tipoLimitacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoLimitacion', is_array($tipoLimitacion) ? implode(', ', $tipoLimitacion) : var_export($tipoLimitacion, true), implode(', ', \EnumType\TipoLimitacion::getValidValues())), __LINE__);
        }
        $this->tipoLimitacion = $tipoLimitacion;
        return $this;
    }
    /**
     * Get velocidadLimitada value
     * @return int
     */
    public function getVelocidadLimitada()
    {
        return $this->velocidadLimitada;
    }
    /**
     * Set velocidadLimitada value
     * @param int $velocidadLimitada
     * @return \StructType\ExcesoVelocidad
     */
    public function setVelocidadLimitada($velocidadLimitada = null)
    {
        // validation for constraint: int
        if (!is_null($velocidadLimitada) && !(is_int($velocidadLimitada) || ctype_digit($velocidadLimitada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($velocidadLimitada, true), gettype($velocidadLimitada)), __LINE__);
        }
        // validation for constraint: maxInclusive(340)
        if (!is_null($velocidadLimitada) && $velocidadLimitada > 340) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 340', var_export($velocidadLimitada, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($velocidadLimitada) && $velocidadLimitada < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($velocidadLimitada, true)), __LINE__);
        }
        $this->velocidadLimitada = $velocidadLimitada;
        return $this;
    }
    /**
     * Get velocidadReal value
     * @return int
     */
    public function getVelocidadReal()
    {
        return $this->velocidadReal;
    }
    /**
     * Set velocidadReal value
     * @param int $velocidadReal
     * @return \StructType\ExcesoVelocidad
     */
    public function setVelocidadReal($velocidadReal = null)
    {
        // validation for constraint: int
        if (!is_null($velocidadReal) && !(is_int($velocidadReal) || ctype_digit($velocidadReal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($velocidadReal, true), gettype($velocidadReal)), __LINE__);
        }
        // validation for constraint: maxInclusive(340)
        if (!is_null($velocidadReal) && $velocidadReal > 340) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 340', var_export($velocidadReal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($velocidadReal) && $velocidadReal < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($velocidadReal, true)), __LINE__);
        }
        $this->velocidadReal = $velocidadReal;
        return $this;
    }
    /**
     * Get aparatoMedida value
     * @return \StructType\AparatoMedida
     */
    public function getAparatoMedida()
    {
        return $this->aparatoMedida;
    }
    /**
     * Set aparatoMedida value
     * @param \StructType\AparatoMedida $aparatoMedida
     * @return \StructType\ExcesoVelocidad
     */
    public function setAparatoMedida(\StructType\AparatoMedida $aparatoMedida = null)
    {
        $this->aparatoMedida = $aparatoMedida;
        return $this;
    }
    /**
     * Get imagenFotoVelocidad value
     * @return \StructType\DocumentoVelocidad[]|null
     */
    public function getImagenFotoVelocidad()
    {
        return $this->imagenFotoVelocidad;
    }
    /**
     * This method is responsible for validating the values passed to the setImagenFotoVelocidad method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImagenFotoVelocidad method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagenFotoVelocidadForArrayConstraintsFromSetImagenFotoVelocidad(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $excesoVelocidadImagenFotoVelocidadItem) {
            // validation for constraint: itemType
            if (!$excesoVelocidadImagenFotoVelocidadItem instanceof \StructType\DocumentoVelocidad) {
                $invalidValues[] = is_object($excesoVelocidadImagenFotoVelocidadItem) ? get_class($excesoVelocidadImagenFotoVelocidadItem) : sprintf('%s(%s)', gettype($excesoVelocidadImagenFotoVelocidadItem), var_export($excesoVelocidadImagenFotoVelocidadItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The imagenFotoVelocidad property can only contain items of type \StructType\DocumentoVelocidad, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set imagenFotoVelocidad value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentoVelocidad[] $imagenFotoVelocidad
     * @return \StructType\ExcesoVelocidad
     */
    public function setImagenFotoVelocidad(array $imagenFotoVelocidad = array())
    {
        // validation for constraint: array
        if ('' !== ($imagenFotoVelocidadArrayErrorMessage = self::validateImagenFotoVelocidadForArrayConstraintsFromSetImagenFotoVelocidad($imagenFotoVelocidad))) {
            throw new \InvalidArgumentException($imagenFotoVelocidadArrayErrorMessage, __LINE__);
        }
        $this->imagenFotoVelocidad = $imagenFotoVelocidad;
        return $this;
    }
    /**
     * Add item to imagenFotoVelocidad value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentoVelocidad $item
     * @return \StructType\ExcesoVelocidad
     */
    public function addToImagenFotoVelocidad(\StructType\DocumentoVelocidad $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentoVelocidad) {
            throw new \InvalidArgumentException(sprintf('The imagenFotoVelocidad property can only contain items of type \StructType\DocumentoVelocidad, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->imagenFotoVelocidad[] = $item;
        return $this;
    }
}
