<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Direccion StructType
 * @subpackage Structs
 */
class Direccion extends AbstractStructBase
{
    /**
     * The normalizada
     * Meta information extracted from the WSDL
     * - documentation: Indicador de si el domicilio es o no normalizado segun formato INE.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $normalizada;
    /**
     * The tipoViaUrbana
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tipoViaUrbana;
    /**
     * The calle
     * Meta information extracted from the WSDL
     * - documentation: Nombre de la via del domicilio del denunciado. | Calle de la via urbana en la que se pone la denuncia.Ej: AVDA MADRID 1
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calle;
    /**
     * The numCalle
     * Meta information extracted from the WSDL
     * - documentation: Numero de la calle del domicilio del denunciado. En caso de indicarse no deberia superar las 10 posiciones.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numCalle;
    /**
     * The kmVia
     * Meta information extracted from the WSDL
     * - documentation: Punto kilometrico del domicilio del denunciado. Por ej: 320
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{1,4}
     * @var int
     */
    public $kmVia;
    /**
     * The hmVia
     * Meta information extracted from the WSDL
     * - documentation: Punto hectometrico del domicilio del denunciado. En caso de indicarse no deberia superar las 2 posiciones.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{1,2}
     * @var int
     */
    public $hmVia;
    /**
     * The bloque
     * Meta information extracted from the WSDL
     * - documentation: Bloque del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bloque;
    /**
     * The portal
     * Meta information extracted from the WSDL
     * - documentation: Portal del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $portal;
    /**
     * The escalera
     * Meta information extracted from the WSDL
     * - documentation: Escalera del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $escalera;
    /**
     * The piso
     * Meta information extracted from the WSDL
     * - documentation: Piso del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $piso;
    /**
     * The letra
     * Meta information extracted from the WSDL
     * - documentation: Letra del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $letra;
    /**
     * The codPostal
     * Meta information extracted from the WSDL
     * - documentation: Codigo postal del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codPostal;
    /**
     * The pueblo
     * Meta information extracted from the WSDL
     * - documentation: Poblacion del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pueblo;
    /**
     * The codLocalidad
     * Meta information extracted from the WSDL
     * - documentation: Codigo de la poblacion del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codLocalidad;
    /**
     * The municipio
     * Meta information extracted from the WSDL
     * - documentation: Municipio del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $municipio;
    /**
     * The codMunicipio
     * Meta information extracted from the WSDL
     * - documentation: Codigo del municipio del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codMunicipio;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Provincia del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $provincia;
    /**
     * The codProvincia
     * Meta information extracted from the WSDL
     * - documentation: Codigo de la provincia del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codProvincia;
    /**
     * The pais
     * Meta information extracted from the WSDL
     * - documentation: Pais del domicilio del denunciado.
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pais;
    /**
     * The codPais
     * Meta information extracted from the WSDL
     * - documentation: Codigo del pais del domicilio del denunciado
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codPais;
    /**
     * The direccionExtranjera
     * Meta information extracted from the WSDL
     * - documentation: Domicilio del denunciado cuando sea extranjero.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $direccionExtranjera;
    /**
     * Constructor method for Direccion
     * @uses Direccion::setNormalizada()
     * @uses Direccion::setTipoViaUrbana()
     * @uses Direccion::setCalle()
     * @uses Direccion::setNumCalle()
     * @uses Direccion::setKmVia()
     * @uses Direccion::setHmVia()
     * @uses Direccion::setBloque()
     * @uses Direccion::setPortal()
     * @uses Direccion::setEscalera()
     * @uses Direccion::setPiso()
     * @uses Direccion::setLetra()
     * @uses Direccion::setCodPostal()
     * @uses Direccion::setPueblo()
     * @uses Direccion::setCodLocalidad()
     * @uses Direccion::setMunicipio()
     * @uses Direccion::setCodMunicipio()
     * @uses Direccion::setProvincia()
     * @uses Direccion::setCodProvincia()
     * @uses Direccion::setPais()
     * @uses Direccion::setCodPais()
     * @uses Direccion::setDireccionExtranjera()
     * @param bool $normalizada
     * @param string $tipoViaUrbana
     * @param string $calle
     * @param string $numCalle
     * @param int $kmVia
     * @param int $hmVia
     * @param string $bloque
     * @param string $portal
     * @param string $escalera
     * @param string $piso
     * @param string $letra
     * @param string $codPostal
     * @param string $pueblo
     * @param string $codLocalidad
     * @param string $municipio
     * @param string $codMunicipio
     * @param string $provincia
     * @param string $codProvincia
     * @param string $pais
     * @param string $codPais
     * @param string $direccionExtranjera
     */
    public function __construct($normalizada = null, $tipoViaUrbana = null, $calle = null, $numCalle = null, $kmVia = null, $hmVia = null, $bloque = null, $portal = null, $escalera = null, $piso = null, $letra = null, $codPostal = null, $pueblo = null, $codLocalidad = null, $municipio = null, $codMunicipio = null, $provincia = null, $codProvincia = null, $pais = null, $codPais = null, $direccionExtranjera = null)
    {
        $this
            ->setNormalizada($normalizada)
            ->setTipoViaUrbana($tipoViaUrbana)
            ->setCalle($calle)
            ->setNumCalle($numCalle)
            ->setKmVia($kmVia)
            ->setHmVia($hmVia)
            ->setBloque($bloque)
            ->setPortal($portal)
            ->setEscalera($escalera)
            ->setPiso($piso)
            ->setLetra($letra)
            ->setCodPostal($codPostal)
            ->setPueblo($pueblo)
            ->setCodLocalidad($codLocalidad)
            ->setMunicipio($municipio)
            ->setCodMunicipio($codMunicipio)
            ->setProvincia($provincia)
            ->setCodProvincia($codProvincia)
            ->setPais($pais)
            ->setCodPais($codPais)
            ->setDireccionExtranjera($direccionExtranjera);
    }
    /**
     * Get normalizada value
     * @return bool|null
     */
    public function getNormalizada()
    {
        return $this->normalizada;
    }
    /**
     * Set normalizada value
     * @param bool $normalizada
     * @return \StructType\Direccion
     */
    public function setNormalizada($normalizada = null)
    {
        // validation for constraint: boolean
        if (!is_null($normalizada) && !is_bool($normalizada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($normalizada, true), gettype($normalizada)), __LINE__);
        }
        $this->normalizada = $normalizada;
        return $this;
    }
    /**
     * Get tipoViaUrbana value
     * @return string|null
     */
    public function getTipoViaUrbana()
    {
        return $this->tipoViaUrbana;
    }
    /**
     * Set tipoViaUrbana value
     * @uses \EnumType\TipoViaUrbana::valueIsValid()
     * @uses \EnumType\TipoViaUrbana::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoViaUrbana
     * @return \StructType\Direccion
     */
    public function setTipoViaUrbana($tipoViaUrbana = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoViaUrbana::valueIsValid($tipoViaUrbana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoViaUrbana', is_array($tipoViaUrbana) ? implode(', ', $tipoViaUrbana) : var_export($tipoViaUrbana, true), implode(', ', \EnumType\TipoViaUrbana::getValidValues())), __LINE__);
        }
        $this->tipoViaUrbana = $tipoViaUrbana;
        return $this;
    }
    /**
     * Get calle value
     * @return string|null
     */
    public function getCalle()
    {
        return $this->calle;
    }
    /**
     * Set calle value
     * @param string $calle
     * @return \StructType\Direccion
     */
    public function setCalle($calle = null)
    {
        // validation for constraint: string
        if (!is_null($calle) && !is_string($calle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calle, true), gettype($calle)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($calle) && mb_strlen($calle) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($calle)), __LINE__);
        }
        $this->calle = $calle;
        return $this;
    }
    /**
     * Get numCalle value
     * @return string|null
     */
    public function getNumCalle()
    {
        return $this->numCalle;
    }
    /**
     * Set numCalle value
     * @param string $numCalle
     * @return \StructType\Direccion
     */
    public function setNumCalle($numCalle = null)
    {
        // validation for constraint: string
        if (!is_null($numCalle) && !is_string($numCalle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numCalle, true), gettype($numCalle)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($numCalle) && mb_strlen($numCalle) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($numCalle)), __LINE__);
        }
        $this->numCalle = $numCalle;
        return $this;
    }
    /**
     * Get kmVia value
     * @return int|null
     */
    public function getKmVia()
    {
        return $this->kmVia;
    }
    /**
     * Set kmVia value
     * @param int $kmVia
     * @return \StructType\Direccion
     */
    public function setKmVia($kmVia = null)
    {
        // validation for constraint: int
        if (!is_null($kmVia) && !(is_int($kmVia) || ctype_digit($kmVia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmVia, true), gettype($kmVia)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,4})
        if (!is_null($kmVia) && !preg_match('/\\d{1,4}/', $kmVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,4}', var_export($kmVia, true)), __LINE__);
        }
        $this->kmVia = $kmVia;
        return $this;
    }
    /**
     * Get hmVia value
     * @return int|null
     */
    public function getHmVia()
    {
        return $this->hmVia;
    }
    /**
     * Set hmVia value
     * @param int $hmVia
     * @return \StructType\Direccion
     */
    public function setHmVia($hmVia = null)
    {
        // validation for constraint: int
        if (!is_null($hmVia) && !(is_int($hmVia) || ctype_digit($hmVia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hmVia, true), gettype($hmVia)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,2})
        if (!is_null($hmVia) && !preg_match('/\\d{1,2}/', $hmVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,2}', var_export($hmVia, true)), __LINE__);
        }
        $this->hmVia = $hmVia;
        return $this;
    }
    /**
     * Get bloque value
     * @return string|null
     */
    public function getBloque()
    {
        return $this->bloque;
    }
    /**
     * Set bloque value
     * @param string $bloque
     * @return \StructType\Direccion
     */
    public function setBloque($bloque = null)
    {
        // validation for constraint: string
        if (!is_null($bloque) && !is_string($bloque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bloque, true), gettype($bloque)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($bloque) && mb_strlen($bloque) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($bloque)), __LINE__);
        }
        $this->bloque = $bloque;
        return $this;
    }
    /**
     * Get portal value
     * @return string|null
     */
    public function getPortal()
    {
        return $this->portal;
    }
    /**
     * Set portal value
     * @param string $portal
     * @return \StructType\Direccion
     */
    public function setPortal($portal = null)
    {
        // validation for constraint: string
        if (!is_null($portal) && !is_string($portal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portal, true), gettype($portal)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($portal) && mb_strlen($portal) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($portal)), __LINE__);
        }
        $this->portal = $portal;
        return $this;
    }
    /**
     * Get escalera value
     * @return string|null
     */
    public function getEscalera()
    {
        return $this->escalera;
    }
    /**
     * Set escalera value
     * @param string $escalera
     * @return \StructType\Direccion
     */
    public function setEscalera($escalera = null)
    {
        // validation for constraint: string
        if (!is_null($escalera) && !is_string($escalera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($escalera, true), gettype($escalera)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($escalera) && mb_strlen($escalera) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($escalera)), __LINE__);
        }
        $this->escalera = $escalera;
        return $this;
    }
    /**
     * Get piso value
     * @return string|null
     */
    public function getPiso()
    {
        return $this->piso;
    }
    /**
     * Set piso value
     * @param string $piso
     * @return \StructType\Direccion
     */
    public function setPiso($piso = null)
    {
        // validation for constraint: string
        if (!is_null($piso) && !is_string($piso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($piso, true), gettype($piso)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($piso) && mb_strlen($piso) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($piso)), __LINE__);
        }
        $this->piso = $piso;
        return $this;
    }
    /**
     * Get letra value
     * @return string|null
     */
    public function getLetra()
    {
        return $this->letra;
    }
    /**
     * Set letra value
     * @param string $letra
     * @return \StructType\Direccion
     */
    public function setLetra($letra = null)
    {
        // validation for constraint: string
        if (!is_null($letra) && !is_string($letra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letra, true), gettype($letra)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($letra) && mb_strlen($letra) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($letra)), __LINE__);
        }
        $this->letra = $letra;
        return $this;
    }
    /**
     * Get codPostal value
     * @return string|null
     */
    public function getCodPostal()
    {
        return $this->codPostal;
    }
    /**
     * Set codPostal value
     * @param string $codPostal
     * @return \StructType\Direccion
     */
    public function setCodPostal($codPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codPostal) && !is_string($codPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codPostal, true), gettype($codPostal)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($codPostal) && mb_strlen($codPostal) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($codPostal)), __LINE__);
        }
        $this->codPostal = $codPostal;
        return $this;
    }
    /**
     * Get pueblo value
     * @return string|null
     */
    public function getPueblo()
    {
        return $this->pueblo;
    }
    /**
     * Set pueblo value
     * @param string $pueblo
     * @return \StructType\Direccion
     */
    public function setPueblo($pueblo = null)
    {
        // validation for constraint: string
        if (!is_null($pueblo) && !is_string($pueblo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pueblo, true), gettype($pueblo)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($pueblo) && mb_strlen($pueblo) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($pueblo)), __LINE__);
        }
        $this->pueblo = $pueblo;
        return $this;
    }
    /**
     * Get codLocalidad value
     * @return string|null
     */
    public function getCodLocalidad()
    {
        return $this->codLocalidad;
    }
    /**
     * Set codLocalidad value
     * @param string $codLocalidad
     * @return \StructType\Direccion
     */
    public function setCodLocalidad($codLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($codLocalidad) && !is_string($codLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codLocalidad, true), gettype($codLocalidad)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($codLocalidad) && mb_strlen($codLocalidad) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($codLocalidad)), __LINE__);
        }
        $this->codLocalidad = $codLocalidad;
        return $this;
    }
    /**
     * Get municipio value
     * @return string|null
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }
    /**
     * Set municipio value
     * @param string $municipio
     * @return \StructType\Direccion
     */
    public function setMunicipio($municipio = null)
    {
        // validation for constraint: string
        if (!is_null($municipio) && !is_string($municipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipio, true), gettype($municipio)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($municipio) && mb_strlen($municipio) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($municipio)), __LINE__);
        }
        $this->municipio = $municipio;
        return $this;
    }
    /**
     * Get codMunicipio value
     * @return string|null
     */
    public function getCodMunicipio()
    {
        return $this->codMunicipio;
    }
    /**
     * Set codMunicipio value
     * @param string $codMunicipio
     * @return \StructType\Direccion
     */
    public function setCodMunicipio($codMunicipio = null)
    {
        // validation for constraint: string
        if (!is_null($codMunicipio) && !is_string($codMunicipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codMunicipio, true), gettype($codMunicipio)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($codMunicipio) && mb_strlen($codMunicipio) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($codMunicipio)), __LINE__);
        }
        $this->codMunicipio = $codMunicipio;
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \StructType\Direccion
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($provincia) && mb_strlen($provincia) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
    /**
     * Get codProvincia value
     * @return string|null
     */
    public function getCodProvincia()
    {
        return $this->codProvincia;
    }
    /**
     * Set codProvincia value
     * @param string $codProvincia
     * @return \StructType\Direccion
     */
    public function setCodProvincia($codProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($codProvincia) && !is_string($codProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codProvincia, true), gettype($codProvincia)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($codProvincia) && mb_strlen($codProvincia) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($codProvincia)), __LINE__);
        }
        $this->codProvincia = $codProvincia;
        return $this;
    }
    /**
     * Get pais value
     * @return string|null
     */
    public function getPais()
    {
        return $this->pais;
    }
    /**
     * Set pais value
     * @param string $pais
     * @return \StructType\Direccion
     */
    public function setPais($pais = null)
    {
        // validation for constraint: string
        if (!is_null($pais) && !is_string($pais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pais, true), gettype($pais)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($pais) && mb_strlen($pais) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($pais)), __LINE__);
        }
        $this->pais = $pais;
        return $this;
    }
    /**
     * Get codPais value
     * @return string|null
     */
    public function getCodPais()
    {
        return $this->codPais;
    }
    /**
     * Set codPais value
     * @param string $codPais
     * @return \StructType\Direccion
     */
    public function setCodPais($codPais = null)
    {
        // validation for constraint: string
        if (!is_null($codPais) && !is_string($codPais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codPais, true), gettype($codPais)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($codPais) && mb_strlen($codPais) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($codPais)), __LINE__);
        }
        $this->codPais = $codPais;
        return $this;
    }
    /**
     * Get direccionExtranjera value
     * @return string|null
     */
    public function getDireccionExtranjera()
    {
        return $this->direccionExtranjera;
    }
    /**
     * Set direccionExtranjera value
     * @param string $direccionExtranjera
     * @return \StructType\Direccion
     */
    public function setDireccionExtranjera($direccionExtranjera = null)
    {
        // validation for constraint: string
        if (!is_null($direccionExtranjera) && !is_string($direccionExtranjera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccionExtranjera, true), gettype($direccionExtranjera)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($direccionExtranjera) && mb_strlen($direccionExtranjera) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($direccionExtranjera)), __LINE__);
        }
        $this->direccionExtranjera = $direccionExtranjera;
        return $this;
    }
}
