<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ayuntamiento StructType
 * @subpackage Structs
 */
class Ayuntamiento extends AbstractStructBase
{
    /**
     * The idAgentePoliciaUrbana
     * Meta information extracted from the WSDL
     * - documentation: Identificador del policia denunciante. Ej:3467
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idAgentePoliciaUrbana;
    /**
     * The idAyuntamiento
     * Meta information extracted from the WSDL
     * - documentation: Ayuntamiento denunciante. Codigo INE Ayuntamiento al que pertenece el agente denunciante. Ej:
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idAyuntamiento;
    /**
     * Constructor method for Ayuntamiento
     * @uses Ayuntamiento::setIdAgentePoliciaUrbana()
     * @uses Ayuntamiento::setIdAyuntamiento()
     * @param string $idAgentePoliciaUrbana
     * @param string $idAyuntamiento
     */
    public function __construct($idAgentePoliciaUrbana = null, $idAyuntamiento = null)
    {
        $this
            ->setIdAgentePoliciaUrbana($idAgentePoliciaUrbana)
            ->setIdAyuntamiento($idAyuntamiento);
    }
    /**
     * Get idAgentePoliciaUrbana value
     * @return string
     */
    public function getIdAgentePoliciaUrbana()
    {
        return $this->idAgentePoliciaUrbana;
    }
    /**
     * Set idAgentePoliciaUrbana value
     * @param string $idAgentePoliciaUrbana
     * @return \StructType\Ayuntamiento
     */
    public function setIdAgentePoliciaUrbana($idAgentePoliciaUrbana = null)
    {
        // validation for constraint: string
        if (!is_null($idAgentePoliciaUrbana) && !is_string($idAgentePoliciaUrbana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAgentePoliciaUrbana, true), gettype($idAgentePoliciaUrbana)), __LINE__);
        }
        $this->idAgentePoliciaUrbana = $idAgentePoliciaUrbana;
        return $this;
    }
    /**
     * Get idAyuntamiento value
     * @return string
     */
    public function getIdAyuntamiento()
    {
        return $this->idAyuntamiento;
    }
    /**
     * Set idAyuntamiento value
     * @param string $idAyuntamiento
     * @return \StructType\Ayuntamiento
     */
    public function setIdAyuntamiento($idAyuntamiento = null)
    {
        // validation for constraint: string
        if (!is_null($idAyuntamiento) && !is_string($idAyuntamiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAyuntamiento, true), gettype($idAyuntamiento)), __LINE__);
        }
        $this->idAyuntamiento = $idAyuntamiento;
        return $this;
    }
}
