<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Suspension StructType
 * Meta information extracted from the WSDL
 * - documentation: Suspension expresada en dias, meses o annos. Debera indicarse o bien el numero de dias o de meses o de annos.
 * @subpackage Structs
 */
class Suspension extends AbstractStructBase
{
    /**
     * The numDia
     * Meta information extracted from the WSDL
     * - documentation: Dias de suspension
     * - choice: numDia | numMes | numAno
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numDia;
    /**
     * The numMes
     * Meta information extracted from the WSDL
     * - documentation: Meses de suspension
     * - choice: numDia | numMes | numAno
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numMes;
    /**
     * The numAno
     * Meta information extracted from the WSDL
     * - documentation: Annos de suspension
     * - choice: numDia | numMes | numAno
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numAno;
    /**
     * Constructor method for Suspension
     * @uses Suspension::setNumDia()
     * @uses Suspension::setNumMes()
     * @uses Suspension::setNumAno()
     * @param int $numDia
     * @param int $numMes
     * @param int $numAno
     */
    public function __construct($numDia = null, $numMes = null, $numAno = null)
    {
        $this
            ->setNumDia($numDia)
            ->setNumMes($numMes)
            ->setNumAno($numAno);
    }
    /**
     * Get numDia value
     * @return int|null
     */
    public function getNumDia()
    {
        return isset($this->numDia) ? $this->numDia : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumDia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumDia method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumDiaForChoiceConstraintsFromSetNumDia($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'numMes',
            'numAno',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property numDia can\'t be set as the property %s is already set. Only one property must be set among these properties: numDia, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set numDia value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $numDia
     * @return \StructType\Suspension
     */
    public function setNumDia($numDia = null)
    {
        // validation for constraint: int
        if (!is_null($numDia) && !(is_int($numDia) || ctype_digit($numDia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numDia, true), gettype($numDia)), __LINE__);
        }
        // validation for constraint: choice(numDia, numMes, numAno)
        if ('' !== ($numDiaChoiceErrorMessage = self::validateNumDiaForChoiceConstraintsFromSetNumDia($numDia))) {
            throw new \InvalidArgumentException($numDiaChoiceErrorMessage, __LINE__);
        }
        if (is_null($numDia) || (is_array($numDia) && empty($numDia))) {
            unset($this->numDia);
        } else {
            $this->numDia = $numDia;
        }
        return $this;
    }
    /**
     * Get numMes value
     * @return int|null
     */
    public function getNumMes()
    {
        return isset($this->numMes) ? $this->numMes : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumMes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumMes method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumMesForChoiceConstraintsFromSetNumMes($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'numDia',
            'numAno',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property numMes can\'t be set as the property %s is already set. Only one property must be set among these properties: numMes, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set numMes value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $numMes
     * @return \StructType\Suspension
     */
    public function setNumMes($numMes = null)
    {
        // validation for constraint: int
        if (!is_null($numMes) && !(is_int($numMes) || ctype_digit($numMes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMes, true), gettype($numMes)), __LINE__);
        }
        // validation for constraint: choice(numDia, numMes, numAno)
        if ('' !== ($numMesChoiceErrorMessage = self::validateNumMesForChoiceConstraintsFromSetNumMes($numMes))) {
            throw new \InvalidArgumentException($numMesChoiceErrorMessage, __LINE__);
        }
        if (is_null($numMes) || (is_array($numMes) && empty($numMes))) {
            unset($this->numMes);
        } else {
            $this->numMes = $numMes;
        }
        return $this;
    }
    /**
     * Get numAno value
     * @return int|null
     */
    public function getNumAno()
    {
        return isset($this->numAno) ? $this->numAno : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumAno method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumAno method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumAnoForChoiceConstraintsFromSetNumAno($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'numDia',
            'numMes',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property numAno can\'t be set as the property %s is already set. Only one property must be set among these properties: numAno, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set numAno value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $numAno
     * @return \StructType\Suspension
     */
    public function setNumAno($numAno = null)
    {
        // validation for constraint: int
        if (!is_null($numAno) && !(is_int($numAno) || ctype_digit($numAno))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numAno, true), gettype($numAno)), __LINE__);
        }
        // validation for constraint: choice(numDia, numMes, numAno)
        if ('' !== ($numAnoChoiceErrorMessage = self::validateNumAnoForChoiceConstraintsFromSetNumAno($numAno))) {
            throw new \InvalidArgumentException($numAnoChoiceErrorMessage, __LINE__);
        }
        if (is_null($numAno) || (is_array($numAno) && empty($numAno))) {
            unset($this->numAno);
        } else {
            $this->numAno = $numAno;
        }
        return $this;
    }
}
