<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expediente StructType
 * @subpackage Structs
 */
class Expediente extends AbstractStructBase
{
    /**
     * The idJefatura
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la jefatura instructora del expediente.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idJefatura;
    /**
     * The fechaHoraDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora del expediente.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FechaHora
     */
    public $fechaHoraDenuncia;
    /**
     * The preceptoInfringido
     * Meta information extracted from the WSDL
     * - documentation: Precepto infringido del expediente.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PreceptoInfringido
     */
    public $preceptoInfringido;
    /**
     * The lugarDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Lugar en el que se interpone la denuncia.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LugarDenuncia
     */
    public $lugarDenuncia;
    /**
     * The objetoDenunciado
     * Meta information extracted from the WSDL
     * - documentation: Objeto denunciado en la sancion. Debera indicarse obligatoriamente un objeto denunciado ya sea vehiculo, centro, escuela u otroDenunciado.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ObjetoDenunciado
     */
    public $objetoDenunciado;
    /**
     * The denunciante
     * Meta information extracted from the WSDL
     * - documentation: Denunciante del expediente.Debera indicarse obligatoriamente un denunciante ya sea ATGC, comandancia, ayuntamiento, dgp, portico, helicoptero o voluntaria.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Denunciante
     */
    public $denunciante;
    /**
     * The imagenBoletinDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Boletin del expediente
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Boletin
     */
    public $imagenBoletinDenuncia;
    /**
     * The sancion
     * Meta information extracted from the WSDL
     * - documentation: Datos propios de la sancion.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sancion
     */
    public $sancion;
    /**
     * The denunciado
     * Meta information extracted from the WSDL
     * - documentation: Denunciado de la sancion. Es un dato opcional. Para denuncias no identificadas no debera informarse.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Denunciado
     */
    public $denunciado;
    /**
     * The tutor
     * Meta information extracted from the WSDL
     * - documentation: Tutor del denunciado de la sancion.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Denunciado
     */
    public $tutor;
    /**
     * The notificadoRuta
     * Meta information extracted from the WSDL
     * - documentation: Indicador de si se ha notificado en ruta.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $notificadoRuta;
    /**
     * Constructor method for Expediente
     * @uses Expediente::setIdJefatura()
     * @uses Expediente::setFechaHoraDenuncia()
     * @uses Expediente::setPreceptoInfringido()
     * @uses Expediente::setLugarDenuncia()
     * @uses Expediente::setObjetoDenunciado()
     * @uses Expediente::setDenunciante()
     * @uses Expediente::setImagenBoletinDenuncia()
     * @uses Expediente::setSancion()
     * @uses Expediente::setDenunciado()
     * @uses Expediente::setTutor()
     * @uses Expediente::setNotificadoRuta()
     * @param string $idJefatura
     * @param \StructType\FechaHora $fechaHoraDenuncia
     * @param \StructType\PreceptoInfringido $preceptoInfringido
     * @param \StructType\LugarDenuncia $lugarDenuncia
     * @param \StructType\ObjetoDenunciado $objetoDenunciado
     * @param \StructType\Denunciante $denunciante
     * @param \StructType\Boletin $imagenBoletinDenuncia
     * @param \StructType\Sancion $sancion
     * @param \StructType\Denunciado $denunciado
     * @param \StructType\Denunciado $tutor
     * @param bool $notificadoRuta
     */
    public function __construct($idJefatura = null, \StructType\FechaHora $fechaHoraDenuncia = null, \StructType\PreceptoInfringido $preceptoInfringido = null, \StructType\LugarDenuncia $lugarDenuncia = null, \StructType\ObjetoDenunciado $objetoDenunciado = null, \StructType\Denunciante $denunciante = null, \StructType\Boletin $imagenBoletinDenuncia = null, \StructType\Sancion $sancion = null, \StructType\Denunciado $denunciado = null, \StructType\Denunciado $tutor = null, $notificadoRuta = null)
    {
        $this
            ->setIdJefatura($idJefatura)
            ->setFechaHoraDenuncia($fechaHoraDenuncia)
            ->setPreceptoInfringido($preceptoInfringido)
            ->setLugarDenuncia($lugarDenuncia)
            ->setObjetoDenunciado($objetoDenunciado)
            ->setDenunciante($denunciante)
            ->setImagenBoletinDenuncia($imagenBoletinDenuncia)
            ->setSancion($sancion)
            ->setDenunciado($denunciado)
            ->setTutor($tutor)
            ->setNotificadoRuta($notificadoRuta);
    }
    /**
     * Get idJefatura value
     * @return string
     */
    public function getIdJefatura()
    {
        return $this->idJefatura;
    }
    /**
     * Set idJefatura value
     * @uses \EnumType\Jefatura::valueIsValid()
     * @uses \EnumType\Jefatura::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idJefatura
     * @return \StructType\Expediente
     */
    public function setIdJefatura($idJefatura = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Jefatura::valueIsValid($idJefatura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Jefatura', is_array($idJefatura) ? implode(', ', $idJefatura) : var_export($idJefatura, true), implode(', ', \EnumType\Jefatura::getValidValues())), __LINE__);
        }
        $this->idJefatura = $idJefatura;
        return $this;
    }
    /**
     * Get fechaHoraDenuncia value
     * @return \StructType\FechaHora
     */
    public function getFechaHoraDenuncia()
    {
        return $this->fechaHoraDenuncia;
    }
    /**
     * Set fechaHoraDenuncia value
     * @param \StructType\FechaHora $fechaHoraDenuncia
     * @return \StructType\Expediente
     */
    public function setFechaHoraDenuncia(\StructType\FechaHora $fechaHoraDenuncia = null)
    {
        $this->fechaHoraDenuncia = $fechaHoraDenuncia;
        return $this;
    }
    /**
     * Get preceptoInfringido value
     * @return \StructType\PreceptoInfringido
     */
    public function getPreceptoInfringido()
    {
        return $this->preceptoInfringido;
    }
    /**
     * Set preceptoInfringido value
     * @param \StructType\PreceptoInfringido $preceptoInfringido
     * @return \StructType\Expediente
     */
    public function setPreceptoInfringido(\StructType\PreceptoInfringido $preceptoInfringido = null)
    {
        $this->preceptoInfringido = $preceptoInfringido;
        return $this;
    }
    /**
     * Get lugarDenuncia value
     * @return \StructType\LugarDenuncia
     */
    public function getLugarDenuncia()
    {
        return $this->lugarDenuncia;
    }
    /**
     * Set lugarDenuncia value
     * @param \StructType\LugarDenuncia $lugarDenuncia
     * @return \StructType\Expediente
     */
    public function setLugarDenuncia(\StructType\LugarDenuncia $lugarDenuncia = null)
    {
        $this->lugarDenuncia = $lugarDenuncia;
        return $this;
    }
    /**
     * Get objetoDenunciado value
     * @return \StructType\ObjetoDenunciado
     */
    public function getObjetoDenunciado()
    {
        return $this->objetoDenunciado;
    }
    /**
     * Set objetoDenunciado value
     * @param \StructType\ObjetoDenunciado $objetoDenunciado
     * @return \StructType\Expediente
     */
    public function setObjetoDenunciado(\StructType\ObjetoDenunciado $objetoDenunciado = null)
    {
        $this->objetoDenunciado = $objetoDenunciado;
        return $this;
    }
    /**
     * Get denunciante value
     * @return \StructType\Denunciante
     */
    public function getDenunciante()
    {
        return $this->denunciante;
    }
    /**
     * Set denunciante value
     * @param \StructType\Denunciante $denunciante
     * @return \StructType\Expediente
     */
    public function setDenunciante(\StructType\Denunciante $denunciante = null)
    {
        $this->denunciante = $denunciante;
        return $this;
    }
    /**
     * Get imagenBoletinDenuncia value
     * @return \StructType\Boletin|null
     */
    public function getImagenBoletinDenuncia()
    {
        return $this->imagenBoletinDenuncia;
    }
    /**
     * Set imagenBoletinDenuncia value
     * @param \StructType\Boletin $imagenBoletinDenuncia
     * @return \StructType\Expediente
     */
    public function setImagenBoletinDenuncia(\StructType\Boletin $imagenBoletinDenuncia = null)
    {
        $this->imagenBoletinDenuncia = $imagenBoletinDenuncia;
        return $this;
    }
    /**
     * Get sancion value
     * @return \StructType\Sancion|null
     */
    public function getSancion()
    {
        return $this->sancion;
    }
    /**
     * Set sancion value
     * @param \StructType\Sancion $sancion
     * @return \StructType\Expediente
     */
    public function setSancion(\StructType\Sancion $sancion = null)
    {
        $this->sancion = $sancion;
        return $this;
    }
    /**
     * Get denunciado value
     * @return \StructType\Denunciado|null
     */
    public function getDenunciado()
    {
        return $this->denunciado;
    }
    /**
     * Set denunciado value
     * @param \StructType\Denunciado $denunciado
     * @return \StructType\Expediente
     */
    public function setDenunciado(\StructType\Denunciado $denunciado = null)
    {
        $this->denunciado = $denunciado;
        return $this;
    }
    /**
     * Get tutor value
     * @return \StructType\Denunciado|null
     */
    public function getTutor()
    {
        return $this->tutor;
    }
    /**
     * Set tutor value
     * @param \StructType\Denunciado $tutor
     * @return \StructType\Expediente
     */
    public function setTutor(\StructType\Denunciado $tutor = null)
    {
        $this->tutor = $tutor;
        return $this;
    }
    /**
     * Get notificadoRuta value
     * @return bool|null
     */
    public function getNotificadoRuta()
    {
        return $this->notificadoRuta;
    }
    /**
     * Set notificadoRuta value
     * @param bool $notificadoRuta
     * @return \StructType\Expediente
     */
    public function setNotificadoRuta($notificadoRuta = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificadoRuta) && !is_bool($notificadoRuta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificadoRuta, true), gettype($notificadoRuta)), __LINE__);
        }
        $this->notificadoRuta = $notificadoRuta;
        return $this;
    }
}
