<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Denunciado StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacion del denunciado del expediente.
 * @subpackage Structs
 */
class Denunciado extends AbstractStructBase
{
    /**
     * The tipoDenunciado
     * Meta information extracted from the WSDL
     * - documentation: Tipo de denunciado. Inicialmente los valores seran CONDUCTOR o TITULAR.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tipoDenunciado;
    /**
     * The dni
     * Meta information extracted from the WSDL
     * - documentation: Documento oficial de identificacion del denunciado. En caso de indicarse deberia ser un DNI, NIE o CIF valido y deberia tener 9 posiciones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dni;
    /**
     * The nombre
     * Meta information extracted from the WSDL
     * - documentation: Nombre del denunciado.
     * - base: xsd:string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nombre;
    /**
     * The primerApellido
     * Meta information extracted from the WSDL
     * - documentation: Primer apellido del denunciado.
     * - base: xsd:string
     * - maxLength: 26
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primerApellido;
    /**
     * The segundoApellido
     * Meta information extracted from the WSDL
     * - documentation: Segundo apellido del denunciado.
     * - base: xsd:string
     * - maxLength: 26
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $segundoApellido;
    /**
     * The direccion
     * Meta information extracted from the WSDL
     * - documentation: Domicilio del denunciado.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Direccion
     */
    public $direccion;
    /**
     * Constructor method for Denunciado
     * @uses Denunciado::setTipoDenunciado()
     * @uses Denunciado::setDni()
     * @uses Denunciado::setNombre()
     * @uses Denunciado::setPrimerApellido()
     * @uses Denunciado::setSegundoApellido()
     * @uses Denunciado::setDireccion()
     * @param string $tipoDenunciado
     * @param string $dni
     * @param string $nombre
     * @param string $primerApellido
     * @param string $segundoApellido
     * @param \StructType\Direccion $direccion
     */
    public function __construct($tipoDenunciado = null, $dni = null, $nombre = null, $primerApellido = null, $segundoApellido = null, \StructType\Direccion $direccion = null)
    {
        $this
            ->setTipoDenunciado($tipoDenunciado)
            ->setDni($dni)
            ->setNombre($nombre)
            ->setPrimerApellido($primerApellido)
            ->setSegundoApellido($segundoApellido)
            ->setDireccion($direccion);
    }
    /**
     * Get tipoDenunciado value
     * @return string|null
     */
    public function getTipoDenunciado()
    {
        return $this->tipoDenunciado;
    }
    /**
     * Set tipoDenunciado value
     * @param string $tipoDenunciado
     * @return \StructType\Denunciado
     */
    public function setTipoDenunciado($tipoDenunciado = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDenunciado) && !is_string($tipoDenunciado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDenunciado, true), gettype($tipoDenunciado)), __LINE__);
        }
        $this->tipoDenunciado = $tipoDenunciado;
        return $this;
    }
    /**
     * Get dni value
     * @return string|null
     */
    public function getDni()
    {
        return $this->dni;
    }
    /**
     * Set dni value
     * @param string $dni
     * @return \StructType\Denunciado
     */
    public function setDni($dni = null)
    {
        // validation for constraint: string
        if (!is_null($dni) && !is_string($dni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dni, true), gettype($dni)), __LINE__);
        }
        $this->dni = $dni;
        return $this;
    }
    /**
     * Get nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\Denunciado
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($nombre) && mb_strlen($nombre) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
    /**
     * Get primerApellido value
     * @return string|null
     */
    public function getPrimerApellido()
    {
        return $this->primerApellido;
    }
    /**
     * Set primerApellido value
     * @param string $primerApellido
     * @return \StructType\Denunciado
     */
    public function setPrimerApellido($primerApellido = null)
    {
        // validation for constraint: string
        if (!is_null($primerApellido) && !is_string($primerApellido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primerApellido, true), gettype($primerApellido)), __LINE__);
        }
        // validation for constraint: maxLength(26)
        if (!is_null($primerApellido) && mb_strlen($primerApellido) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 26', mb_strlen($primerApellido)), __LINE__);
        }
        $this->primerApellido = $primerApellido;
        return $this;
    }
    /**
     * Get segundoApellido value
     * @return string|null
     */
    public function getSegundoApellido()
    {
        return $this->segundoApellido;
    }
    /**
     * Set segundoApellido value
     * @param string $segundoApellido
     * @return \StructType\Denunciado
     */
    public function setSegundoApellido($segundoApellido = null)
    {
        // validation for constraint: string
        if (!is_null($segundoApellido) && !is_string($segundoApellido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segundoApellido, true), gettype($segundoApellido)), __LINE__);
        }
        // validation for constraint: maxLength(26)
        if (!is_null($segundoApellido) && mb_strlen($segundoApellido) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 26', mb_strlen($segundoApellido)), __LINE__);
        }
        $this->segundoApellido = $segundoApellido;
        return $this;
    }
    /**
     * Get direccion value
     * @return \StructType\Direccion|null
     */
    public function getDireccion()
    {
        return $this->direccion;
    }
    /**
     * Set direccion value
     * @param \StructType\Direccion $direccion
     * @return \StructType\Denunciado
     */
    public function setDireccion(\StructType\Direccion $direccion = null)
    {
        $this->direccion = $direccion;
        return $this;
    }
}
