<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentroReconocimiento StructType
 * @subpackage Structs
 */
class CentroReconocimiento extends AbstractStructBase
{
    /**
     * The descripcion
     * Meta information extracted from the WSDL
     * - documentation: Descripcion del centro de reconocimiento sancionado, normalemente indica su nombre. Ej: SIGLO XXI | Descripcion de la escuela sancionada, normalmente indica su nombre. Ej:ZAIDIN
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descripcion;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Identificador del centro de reconocimiento sancionado.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * Constructor method for CentroReconocimiento
     * @uses CentroReconocimiento::setDescripcion()
     * @uses CentroReconocimiento::setId()
     * @param string $descripcion
     * @param string $id
     */
    public function __construct($descripcion = null, $id = null)
    {
        $this
            ->setDescripcion($descripcion)
            ->setId($id);
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\CentroReconocimiento
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($descripcion) && mb_strlen($descripcion) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\CentroReconocimiento
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
