<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Boletin StructType
 * Meta information extracted from the WSDL
 * - documentation: Boletin de denuncia digitalizado.
 * @subpackage Structs
 */
class Boletin extends AbstractStructBase
{
    /**
     * The imagenBoletinDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Contenido de la imagen del boletin de denuncia.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $imagenBoletinDenuncia;
    /**
     * Constructor method for Boletin
     * @uses Boletin::setImagenBoletinDenuncia()
     * @param string $imagenBoletinDenuncia
     */
    public function __construct($imagenBoletinDenuncia = null)
    {
        $this
            ->setImagenBoletinDenuncia($imagenBoletinDenuncia);
    }
    /**
     * Get imagenBoletinDenuncia value
     * @return string
     */
    public function getImagenBoletinDenuncia()
    {
        return $this->imagenBoletinDenuncia;
    }
    /**
     * Set imagenBoletinDenuncia value
     * @param string $imagenBoletinDenuncia
     * @return \StructType\Boletin
     */
    public function setImagenBoletinDenuncia($imagenBoletinDenuncia = null)
    {
        // validation for constraint: string
        if (!is_null($imagenBoletinDenuncia) && !is_string($imagenBoletinDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imagenBoletinDenuncia, true), gettype($imagenBoletinDenuncia)), __LINE__);
        }
        $this->imagenBoletinDenuncia = $imagenBoletinDenuncia;
        return $this;
    }
}
