<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Alcoholemia StructType
 * Meta information extracted from the WSDL
 * - documentation: Datos especificos de un expediente de alcoholemia. Debera indicarse o bien una medidion en aire o bien una medicion en sangre. Informar el ticket de alcoholemia es opcional.
 * @subpackage Structs
 */
class Alcoholemia extends AbstractStructBase
{
    /**
     * The medicionAireEspirado
     * Meta information extracted from the WSDL
     * - documentation: Medicion de la prueba de alcoholemia en aire
     * - choice: medicionAireEspirado | medicionSangre
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MedicionAireEspirado
     */
    public $medicionAireEspirado;
    /**
     * The medicionSangre
     * Meta information extracted from the WSDL
     * - documentation: Medicion de la prueba de alcoholemia en sangre
     * - choice: medicionAireEspirado | medicionSangre
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MedicionSangre
     */
    public $medicionSangre;
    /**
     * The imagenTicketAlcoholemia
     * Meta information extracted from the WSDL
     * - documentation: Ticket de la prueba de alcoholemia realizada.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Documento
     */
    public $imagenTicketAlcoholemia;
    /**
     * Constructor method for Alcoholemia
     * @uses Alcoholemia::setMedicionAireEspirado()
     * @uses Alcoholemia::setMedicionSangre()
     * @uses Alcoholemia::setImagenTicketAlcoholemia()
     * @param \StructType\MedicionAireEspirado $medicionAireEspirado
     * @param \StructType\MedicionSangre $medicionSangre
     * @param \StructType\Documento $imagenTicketAlcoholemia
     */
    public function __construct(\StructType\MedicionAireEspirado $medicionAireEspirado = null, \StructType\MedicionSangre $medicionSangre = null, \StructType\Documento $imagenTicketAlcoholemia = null)
    {
        $this
            ->setMedicionAireEspirado($medicionAireEspirado)
            ->setMedicionSangre($medicionSangre)
            ->setImagenTicketAlcoholemia($imagenTicketAlcoholemia);
    }
    /**
     * Get medicionAireEspirado value
     * @return \StructType\MedicionAireEspirado|null
     */
    public function getMedicionAireEspirado()
    {
        return isset($this->medicionAireEspirado) ? $this->medicionAireEspirado : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMedicionAireEspirado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMedicionAireEspirado method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMedicionAireEspiradoForChoiceConstraintsFromSetMedicionAireEspirado($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'medicionSangre',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property medicionAireEspirado can\'t be set as the property %s is already set. Only one property must be set among these properties: medicionAireEspirado, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set medicionAireEspirado value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MedicionAireEspirado $medicionAireEspirado
     * @return \StructType\Alcoholemia
     */
    public function setMedicionAireEspirado(\StructType\MedicionAireEspirado $medicionAireEspirado = null)
    {
        // validation for constraint: choice(medicionAireEspirado, medicionSangre)
        if ('' !== ($medicionAireEspiradoChoiceErrorMessage = self::validateMedicionAireEspiradoForChoiceConstraintsFromSetMedicionAireEspirado($medicionAireEspirado))) {
            throw new \InvalidArgumentException($medicionAireEspiradoChoiceErrorMessage, __LINE__);
        }
        if (is_null($medicionAireEspirado) || (is_array($medicionAireEspirado) && empty($medicionAireEspirado))) {
            unset($this->medicionAireEspirado);
        } else {
            $this->medicionAireEspirado = $medicionAireEspirado;
        }
        return $this;
    }
    /**
     * Get medicionSangre value
     * @return \StructType\MedicionSangre|null
     */
    public function getMedicionSangre()
    {
        return isset($this->medicionSangre) ? $this->medicionSangre : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMedicionSangre method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMedicionSangre method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMedicionSangreForChoiceConstraintsFromSetMedicionSangre($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'medicionAireEspirado',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property medicionSangre can\'t be set as the property %s is already set. Only one property must be set among these properties: medicionSangre, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set medicionSangre value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MedicionSangre $medicionSangre
     * @return \StructType\Alcoholemia
     */
    public function setMedicionSangre(\StructType\MedicionSangre $medicionSangre = null)
    {
        // validation for constraint: choice(medicionAireEspirado, medicionSangre)
        if ('' !== ($medicionSangreChoiceErrorMessage = self::validateMedicionSangreForChoiceConstraintsFromSetMedicionSangre($medicionSangre))) {
            throw new \InvalidArgumentException($medicionSangreChoiceErrorMessage, __LINE__);
        }
        if (is_null($medicionSangre) || (is_array($medicionSangre) && empty($medicionSangre))) {
            unset($this->medicionSangre);
        } else {
            $this->medicionSangre = $medicionSangre;
        }
        return $this;
    }
    /**
     * Get imagenTicketAlcoholemia value
     * @return \StructType\Documento|null
     */
    public function getImagenTicketAlcoholemia()
    {
        return $this->imagenTicketAlcoholemia;
    }
    /**
     * Set imagenTicketAlcoholemia value
     * @param \StructType\Documento $imagenTicketAlcoholemia
     * @return \StructType\Alcoholemia
     */
    public function setImagenTicketAlcoholemia(\StructType\Documento $imagenTicketAlcoholemia = null)
    {
        $this->imagenTicketAlcoholemia = $imagenTicketAlcoholemia;
        return $this;
    }
}
