<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adjuntarDocumentoPeticion StructType
 * Meta information extracted from the WSDL
 * - documentation: Peticion de la operacion de adjuntar documentacion
 * @subpackage Structs
 */
class AdjuntarDocumentoPeticion extends AbstractStructBase
{
    /**
     * The expediente
     * Meta information extracted from the WSDL
     * - documentation: Numero de expediente al que se desea adjuntar la documentacion.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NumExpediente
     */
    public $expediente;
    /**
     * The tipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipoDocumento;
    /**
     * The formato
     * Meta information extracted from the WSDL
     * - documentation: Formato o extension del fichero a adjuntar. En caso de no adjuntarse, el documento quedaria sin tipo y por tanto seria incorrecto, por tanto se debe informar en la peticion. La extension debera indicarse sin '.', por ejemplo pdf, gif
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $formato;
    /**
     * The fichero
     * Meta information extracted from the WSDL
     * - documentation: Contenido en bytes del fichero a adjuntar.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $fichero;
    /**
     * The forzarInsercion
     * Meta information extracted from the WSDL
     * - documentation: Indicativo de si se desea forzar la insercion del expediente aunque este no exista. Booleano que en caso de ser true indica que el documento se debe adjuntar obligatoriamente al expediente aunque este no haya sido iniciado en
     * Sanciones. En caso de no indicarse, por defecto su valor es true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $forzarInsercion;
    /**
     * Constructor method for adjuntarDocumentoPeticion
     * @uses AdjuntarDocumentoPeticion::setExpediente()
     * @uses AdjuntarDocumentoPeticion::setTipoDocumento()
     * @uses AdjuntarDocumentoPeticion::setFormato()
     * @uses AdjuntarDocumentoPeticion::setFichero()
     * @uses AdjuntarDocumentoPeticion::setForzarInsercion()
     * @param \StructType\NumExpediente $expediente
     * @param string $tipoDocumento
     * @param string $formato
     * @param string $fichero
     * @param bool $forzarInsercion
     */
    public function __construct(\StructType\NumExpediente $expediente = null, $tipoDocumento = null, $formato = null, $fichero = null, $forzarInsercion = null)
    {
        $this
            ->setExpediente($expediente)
            ->setTipoDocumento($tipoDocumento)
            ->setFormato($formato)
            ->setFichero($fichero)
            ->setForzarInsercion($forzarInsercion);
    }
    /**
     * Get expediente value
     * @return \StructType\NumExpediente
     */
    public function getExpediente()
    {
        return $this->expediente;
    }
    /**
     * Set expediente value
     * @param \StructType\NumExpediente $expediente
     * @return \StructType\AdjuntarDocumentoPeticion
     */
    public function setExpediente(\StructType\NumExpediente $expediente = null)
    {
        $this->expediente = $expediente;
        return $this;
    }
    /**
     * Get tipoDocumento value
     * @return string
     */
    public function getTipoDocumento()
    {
        return $this->tipoDocumento;
    }
    /**
     * Set tipoDocumento value
     * @uses \EnumType\TipoDocumento::valueIsValid()
     * @uses \EnumType\TipoDocumento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoDocumento
     * @return \StructType\AdjuntarDocumentoPeticion
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoDocumento::valueIsValid($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoDocumento', is_array($tipoDocumento) ? implode(', ', $tipoDocumento) : var_export($tipoDocumento, true), implode(', ', \EnumType\TipoDocumento::getValidValues())), __LINE__);
        }
        $this->tipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get formato value
     * @return string
     */
    public function getFormato()
    {
        return $this->formato;
    }
    /**
     * Set formato value
     * @param string $formato
     * @return \StructType\AdjuntarDocumentoPeticion
     */
    public function setFormato($formato = null)
    {
        // validation for constraint: string
        if (!is_null($formato) && !is_string($formato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formato, true), gettype($formato)), __LINE__);
        }
        $this->formato = $formato;
        return $this;
    }
    /**
     * Get fichero value
     * @return string
     */
    public function getFichero()
    {
        return $this->fichero;
    }
    /**
     * Set fichero value
     * @param string $fichero
     * @return \StructType\AdjuntarDocumentoPeticion
     */
    public function setFichero($fichero = null)
    {
        // validation for constraint: string
        if (!is_null($fichero) && !is_string($fichero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fichero, true), gettype($fichero)), __LINE__);
        }
        $this->fichero = $fichero;
        return $this;
    }
    /**
     * Get forzarInsercion value
     * @return bool|null
     */
    public function getForzarInsercion()
    {
        return $this->forzarInsercion;
    }
    /**
     * Set forzarInsercion value
     * @param bool $forzarInsercion
     * @return \StructType\AdjuntarDocumentoPeticion
     */
    public function setForzarInsercion($forzarInsercion = null)
    {
        // validation for constraint: boolean
        if (!is_null($forzarInsercion) && !is_bool($forzarInsercion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forzarInsercion, true), gettype($forzarInsercion)), __LINE__);
        }
        $this->forzarInsercion = $forzarInsercion;
        return $this;
    }
}
