<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reserva ServiceType
 * @subpackage Services
 */
class Reserva extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reservaNumeroDenuncia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReservaNumeroDenunciaPeticion $reservaNumeroDenunciaPeticion
     * @return \StructType\ReservaNumeroDenunciaRespuesta|bool
     */
    public function reservaNumeroDenuncia(\StructType\ReservaNumeroDenunciaPeticion $reservaNumeroDenunciaPeticion)
    {
        try {
            $this->setResult($this->getSoapClient()->reservaNumeroDenuncia($reservaNumeroDenunciaPeticion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReservaNumeroDenunciaRespuesta
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
