<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Es ServiceType
 */
$es = new \ServiceType\Es($options);
/**
 * Sample call for esValidoCertificadoCinemometro operation/method
 */
if ($es->esValidoCertificadoCinemometro(new \StructType\EsValidoCertificadoCinemometroPeticion()) !== false) {
    print_r($es->getResult());
} else {
    print_r($es->getLastError());
}
/**
 * Samples for Existe ServiceType
 */
$existe = new \ServiceType\Existe($options);
/**
 * Sample call for existeCinemometro operation/method
 */
if ($existe->existeCinemometro(new \StructType\ExisteCinemometroPeticion()) !== false) {
    print_r($existe->getResult());
} else {
    print_r($existe->getLastError());
}
/**
 * Sample call for existeExpediente operation/method
 */
if ($existe->existeExpediente(new \StructType\ExisteExpedientePeticion()) !== false) {
    print_r($existe->getResult());
} else {
    print_r($existe->getLastError());
}
/**
 * Samples for Adjuntar ServiceType
 */
$adjuntar = new \ServiceType\Adjuntar($options);
/**
 * Sample call for adjuntarDocumento operation/method
 */
if ($adjuntar->adjuntarDocumento(new \StructType\AdjuntarDocumentoPeticion()) !== false) {
    print_r($adjuntar->getResult());
} else {
    print_r($adjuntar->getLastError());
}
/**
 * Samples for Alta ServiceType
 */
$alta = new \ServiceType\Alta($options);
/**
 * Sample call for altaDenuncia operation/method
 */
if ($alta->altaDenuncia(new \StructType\AltaDenunciaPeticion()) !== false) {
    print_r($alta->getResult());
} else {
    print_r($alta->getLastError());
}
/**
 * Sample call for altaOficio operation/method
 */
if ($alta->altaOficio(new \StructType\AltaOficioPeticion()) !== false) {
    print_r($alta->getResult());
} else {
    print_r($alta->getLastError());
}
/**
 * Samples for Reserva ServiceType
 */
$reserva = new \ServiceType\Reserva($options);
/**
 * Sample call for reservaNumeroDenuncia operation/method
 */
if ($reserva->reservaNumeroDenuncia(new \StructType\ReservaNumeroDenunciaPeticion()) !== false) {
    print_r($reserva->getResult());
} else {
    print_r($reserva->getLastError());
}
