<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sancion StructType
 * Meta information extracted from the WSDL
 * - documentation: Datos propios de una sancion
 * @subpackage Structs
 */
class Sancion extends AbstractStructBase
{
    /**
     * The importeDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Importe de la sancion. Debera tener un formato decimal ddddd.dd.
     * - base: xsd:double
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{1,5}(\.\d{1,2})?
     * @var float
     */
    public $importeDenuncia;
    /**
     * The suspension
     * Meta information extracted from the WSDL
     * - documentation: Suspension de la sancion.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Suspension
     */
    public $suspension;
    /**
     * Constructor method for Sancion
     * @uses Sancion::setImporteDenuncia()
     * @uses Sancion::setSuspension()
     * @param float $importeDenuncia
     * @param \StructType\Suspension $suspension
     */
    public function __construct($importeDenuncia = null, \StructType\Suspension $suspension = null)
    {
        $this
            ->setImporteDenuncia($importeDenuncia)
            ->setSuspension($suspension);
    }
    /**
     * Get importeDenuncia value
     * @return float
     */
    public function getImporteDenuncia()
    {
        return $this->importeDenuncia;
    }
    /**
     * Set importeDenuncia value
     * @param float $importeDenuncia
     * @return \StructType\Sancion
     */
    public function setImporteDenuncia($importeDenuncia = null)
    {
        // validation for constraint: float
        if (!is_null($importeDenuncia) && !(is_float($importeDenuncia) || is_numeric($importeDenuncia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importeDenuncia, true), gettype($importeDenuncia)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,5}(\.\d{1,2})?)
        if (!is_null($importeDenuncia) && !preg_match('/\\d{1,5}(\\.\\d{1,2})?/', $importeDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,5}(\.\d{1,2})?', var_export($importeDenuncia, true)), __LINE__);
        }
        $this->importeDenuncia = $importeDenuncia;
        return $this;
    }
    /**
     * Get suspension value
     * @return \StructType\Suspension|null
     */
    public function getSuspension()
    {
        return $this->suspension;
    }
    /**
     * Set suspension value
     * @param \StructType\Suspension $suspension
     * @return \StructType\Sancion
     */
    public function setSuspension(\StructType\Suspension $suspension = null)
    {
        $this->suspension = $suspension;
        return $this;
    }
}
