<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HechoDenunciado StructType
 * Meta information extracted from the WSDL
 * - documentation: Hecho denunciado del expediente, podra ser general o bien de alcoholemia o bien de velocidad. Adicionalmente se podran informar las aclaraciones y la documentacion.
 * @subpackage Structs
 */
class HechoDenunciado extends AbstractStructBase
{
    /**
     * The hechoCatalogado
     * Meta information extracted from the WSDL
     * - documentation: Informa la opcion que complementa la catalogacion del precepto.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HechoCatalogado
     */
    public $hechoCatalogado;
    /**
     * The alcoholemia
     * Meta information extracted from the WSDL
     * - documentation: Informacion especifica de un expediente de alcoholemia.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Alcoholemia
     */
    public $alcoholemia;
    /**
     * The excesoVelocidad
     * Meta information extracted from the WSDL
     * - documentation: Informacion especifica de un expediente de velocidad.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExcesoVelocidad
     */
    public $excesoVelocidad;
    /**
     * The aclaracionesDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Aclaraciones al hecho catalogado. Seran annadidas al hecho complementario del expediente.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aclaracionesDenuncia;
    /**
     * The documentacion
     * Meta information extracted from the WSDL
     * - documentation: Documentacion adjuta al expediente cuando no sea de velocidad
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Documento[]
     */
    public $documentacion;
    /**
     * Constructor method for HechoDenunciado
     * @uses HechoDenunciado::setHechoCatalogado()
     * @uses HechoDenunciado::setAlcoholemia()
     * @uses HechoDenunciado::setExcesoVelocidad()
     * @uses HechoDenunciado::setAclaracionesDenuncia()
     * @uses HechoDenunciado::setDocumentacion()
     * @param \StructType\HechoCatalogado $hechoCatalogado
     * @param \StructType\Alcoholemia $alcoholemia
     * @param \StructType\ExcesoVelocidad $excesoVelocidad
     * @param string $aclaracionesDenuncia
     * @param \StructType\Documento[] $documentacion
     */
    public function __construct(\StructType\HechoCatalogado $hechoCatalogado = null, \StructType\Alcoholemia $alcoholemia = null, \StructType\ExcesoVelocidad $excesoVelocidad = null, $aclaracionesDenuncia = null, array $documentacion = array())
    {
        $this
            ->setHechoCatalogado($hechoCatalogado)
            ->setAlcoholemia($alcoholemia)
            ->setExcesoVelocidad($excesoVelocidad)
            ->setAclaracionesDenuncia($aclaracionesDenuncia)
            ->setDocumentacion($documentacion);
    }
    /**
     * Get hechoCatalogado value
     * @return \StructType\HechoCatalogado|null
     */
    public function getHechoCatalogado()
    {
        return $this->hechoCatalogado;
    }
    /**
     * Set hechoCatalogado value
     * @param \StructType\HechoCatalogado $hechoCatalogado
     * @return \StructType\HechoDenunciado
     */
    public function setHechoCatalogado(\StructType\HechoCatalogado $hechoCatalogado = null)
    {
        $this->hechoCatalogado = $hechoCatalogado;
        return $this;
    }
    /**
     * Get alcoholemia value
     * @return \StructType\Alcoholemia|null
     */
    public function getAlcoholemia()
    {
        return $this->alcoholemia;
    }
    /**
     * Set alcoholemia value
     * @param \StructType\Alcoholemia $alcoholemia
     * @return \StructType\HechoDenunciado
     */
    public function setAlcoholemia(\StructType\Alcoholemia $alcoholemia = null)
    {
        $this->alcoholemia = $alcoholemia;
        return $this;
    }
    /**
     * Get excesoVelocidad value
     * @return \StructType\ExcesoVelocidad|null
     */
    public function getExcesoVelocidad()
    {
        return $this->excesoVelocidad;
    }
    /**
     * Set excesoVelocidad value
     * @param \StructType\ExcesoVelocidad $excesoVelocidad
     * @return \StructType\HechoDenunciado
     */
    public function setExcesoVelocidad(\StructType\ExcesoVelocidad $excesoVelocidad = null)
    {
        $this->excesoVelocidad = $excesoVelocidad;
        return $this;
    }
    /**
     * Get aclaracionesDenuncia value
     * @return string|null
     */
    public function getAclaracionesDenuncia()
    {
        return $this->aclaracionesDenuncia;
    }
    /**
     * Set aclaracionesDenuncia value
     * @param string $aclaracionesDenuncia
     * @return \StructType\HechoDenunciado
     */
    public function setAclaracionesDenuncia($aclaracionesDenuncia = null)
    {
        // validation for constraint: string
        if (!is_null($aclaracionesDenuncia) && !is_string($aclaracionesDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aclaracionesDenuncia, true), gettype($aclaracionesDenuncia)), __LINE__);
        }
        $this->aclaracionesDenuncia = $aclaracionesDenuncia;
        return $this;
    }
    /**
     * Get documentacion value
     * @return \StructType\Documento[]|null
     */
    public function getDocumentacion()
    {
        return $this->documentacion;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentacion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentacion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentacionForArrayConstraintsFromSetDocumentacion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hechoDenunciadoDocumentacionItem) {
            // validation for constraint: itemType
            if (!$hechoDenunciadoDocumentacionItem instanceof \StructType\Documento) {
                $invalidValues[] = is_object($hechoDenunciadoDocumentacionItem) ? get_class($hechoDenunciadoDocumentacionItem) : sprintf('%s(%s)', gettype($hechoDenunciadoDocumentacionItem), var_export($hechoDenunciadoDocumentacionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documentacion property can only contain items of type \StructType\Documento, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documentacion value
     * @throws \InvalidArgumentException
     * @param \StructType\Documento[] $documentacion
     * @return \StructType\HechoDenunciado
     */
    public function setDocumentacion(array $documentacion = array())
    {
        // validation for constraint: array
        if ('' !== ($documentacionArrayErrorMessage = self::validateDocumentacionForArrayConstraintsFromSetDocumentacion($documentacion))) {
            throw new \InvalidArgumentException($documentacionArrayErrorMessage, __LINE__);
        }
        $this->documentacion = $documentacion;
        return $this;
    }
    /**
     * Add item to documentacion value
     * @throws \InvalidArgumentException
     * @param \StructType\Documento $item
     * @return \StructType\HechoDenunciado
     */
    public function addToDocumentacion(\StructType\Documento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Documento) {
            throw new \InvalidArgumentException(sprintf('The documentacion property can only contain items of type \StructType\Documento, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documentacion[] = $item;
        return $this;
    }
}
