<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FechaHora StructType
 * Meta information extracted from the WSDL
 * - documentation: Fecha y hora de denuncia.
 * @subpackage Structs
 */
class FechaHora extends AbstractStructBase
{
    /**
     * The fechaDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Fecha de denuncia. Se trata de un valor obligatorio y no puede ser ni una fecha futura, ni una fecha anterior a 4 meses. Tiene que cumplir el formato yyyy-mm-dd. Ej: 2013-06-05
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}-(0[0-9]|1[0-2])-([0-2][0-9]|3[0-1])
     * @var string
     */
    public $fechaDenuncia;
    /**
     * The horaDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Hora de denuncia. Tiene que cumplir el formato hh:mm. Ejemplo: 13:19
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (([01][0-9])|(2[0-3])):[0-5][0-9]
     * @var string
     */
    public $horaDenuncia;
    /**
     * Constructor method for FechaHora
     * @uses FechaHora::setFechaDenuncia()
     * @uses FechaHora::setHoraDenuncia()
     * @param string $fechaDenuncia
     * @param string $horaDenuncia
     */
    public function __construct($fechaDenuncia = null, $horaDenuncia = null)
    {
        $this
            ->setFechaDenuncia($fechaDenuncia)
            ->setHoraDenuncia($horaDenuncia);
    }
    /**
     * Get fechaDenuncia value
     * @return string
     */
    public function getFechaDenuncia()
    {
        return $this->fechaDenuncia;
    }
    /**
     * Set fechaDenuncia value
     * @param string $fechaDenuncia
     * @return \StructType\FechaHora
     */
    public function setFechaDenuncia($fechaDenuncia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaDenuncia) && !is_string($fechaDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaDenuncia, true), gettype($fechaDenuncia)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}-(0[0-9]|1[0-2])-([0-2][0-9]|3[0-1]))
        if (!is_null($fechaDenuncia) && !preg_match('/\\d{4}-(0[0-9]|1[0-2])-([0-2][0-9]|3[0-1])/', $fechaDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}-(0[0-9]|1[0-2])-([0-2][0-9]|3[0-1])', var_export($fechaDenuncia, true)), __LINE__);
        }
        $this->fechaDenuncia = $fechaDenuncia;
        return $this;
    }
    /**
     * Get horaDenuncia value
     * @return string
     */
    public function getHoraDenuncia()
    {
        return $this->horaDenuncia;
    }
    /**
     * Set horaDenuncia value
     * @param string $horaDenuncia
     * @return \StructType\FechaHora
     */
    public function setHoraDenuncia($horaDenuncia = null)
    {
        // validation for constraint: string
        if (!is_null($horaDenuncia) && !is_string($horaDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($horaDenuncia, true), gettype($horaDenuncia)), __LINE__);
        }
        // validation for constraint: pattern((([01][0-9])|(2[0-3])):[0-5][0-9])
        if (!is_null($horaDenuncia) && !preg_match('/(([01][0-9])|(2[0-3])):[0-5][0-9]/', $horaDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (([01][0-9])|(2[0-3])):[0-5][0-9]', var_export($horaDenuncia, true)), __LINE__);
        }
        $this->horaDenuncia = $horaDenuncia;
        return $this;
    }
}
