<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Denunciante StructType
 * @subpackage Structs
 */
class Denunciante extends AbstractStructBase
{
    /**
     * The atgc
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo ATGC.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ATGC
     */
    public $atgc;
    /**
     * The comandancia
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo comandancia.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Comandancia
     */
    public $comandancia;
    /**
     * The ayuntamiento
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo ayuntamiento.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ayuntamiento
     */
    public $ayuntamiento;
    /**
     * The dgp
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo DGP.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dgp;
    /**
     * The portico
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo portico.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Portico
     */
    public $portico;
    /**
     * The helicoptero
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo helicoptero.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Helicoptero
     */
    public $helicoptero;
    /**
     * The convAyto
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo convenio ayuntamiento.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConvAyto
     */
    public $convAyto;
    /**
     * The voluntaria
     * Meta information extracted from the WSDL
     * - documentation: Denunciante de tipo voluntaria.
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Voluntaria
     */
    public $voluntaria;
    /**
     * The dron
     * Meta information extracted from the WSDL
     * - choice: atgc | comandancia | ayuntamiento | dgp | portico | helicoptero | convAyto | voluntaria | dron
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Dron
     */
    public $dron;
    /**
     * Constructor method for Denunciante
     * @uses Denunciante::setAtgc()
     * @uses Denunciante::setComandancia()
     * @uses Denunciante::setAyuntamiento()
     * @uses Denunciante::setDgp()
     * @uses Denunciante::setPortico()
     * @uses Denunciante::setHelicoptero()
     * @uses Denunciante::setConvAyto()
     * @uses Denunciante::setVoluntaria()
     * @uses Denunciante::setDron()
     * @param \StructType\ATGC $atgc
     * @param \StructType\Comandancia $comandancia
     * @param \StructType\Ayuntamiento $ayuntamiento
     * @param string $dgp
     * @param \StructType\Portico $portico
     * @param \StructType\Helicoptero $helicoptero
     * @param \StructType\ConvAyto $convAyto
     * @param \StructType\Voluntaria $voluntaria
     * @param \StructType\Dron $dron
     */
    public function __construct(\StructType\ATGC $atgc = null, \StructType\Comandancia $comandancia = null, \StructType\Ayuntamiento $ayuntamiento = null, $dgp = null, \StructType\Portico $portico = null, \StructType\Helicoptero $helicoptero = null, \StructType\ConvAyto $convAyto = null, \StructType\Voluntaria $voluntaria = null, \StructType\Dron $dron = null)
    {
        $this
            ->setAtgc($atgc)
            ->setComandancia($comandancia)
            ->setAyuntamiento($ayuntamiento)
            ->setDgp($dgp)
            ->setPortico($portico)
            ->setHelicoptero($helicoptero)
            ->setConvAyto($convAyto)
            ->setVoluntaria($voluntaria)
            ->setDron($dron);
    }
    /**
     * Get atgc value
     * @return \StructType\ATGC|null
     */
    public function getAtgc()
    {
        return isset($this->atgc) ? $this->atgc : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAtgc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAtgc method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAtgcForChoiceConstraintsFromSetAtgc($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'comandancia',
            'ayuntamiento',
            'dgp',
            'portico',
            'helicoptero',
            'convAyto',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property atgc can\'t be set as the property %s is already set. Only one property must be set among these properties: atgc, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set atgc value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ATGC $atgc
     * @return \StructType\Denunciante
     */
    public function setAtgc(\StructType\ATGC $atgc = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($atgcChoiceErrorMessage = self::validateAtgcForChoiceConstraintsFromSetAtgc($atgc))) {
            throw new \InvalidArgumentException($atgcChoiceErrorMessage, __LINE__);
        }
        if (is_null($atgc) || (is_array($atgc) && empty($atgc))) {
            unset($this->atgc);
        } else {
            $this->atgc = $atgc;
        }
        return $this;
    }
    /**
     * Get comandancia value
     * @return \StructType\Comandancia|null
     */
    public function getComandancia()
    {
        return isset($this->comandancia) ? $this->comandancia : null;
    }
    /**
     * This method is responsible for validating the value passed to the setComandancia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComandancia method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateComandanciaForChoiceConstraintsFromSetComandancia($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'ayuntamiento',
            'dgp',
            'portico',
            'helicoptero',
            'convAyto',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property comandancia can\'t be set as the property %s is already set. Only one property must be set among these properties: comandancia, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set comandancia value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Comandancia $comandancia
     * @return \StructType\Denunciante
     */
    public function setComandancia(\StructType\Comandancia $comandancia = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($comandanciaChoiceErrorMessage = self::validateComandanciaForChoiceConstraintsFromSetComandancia($comandancia))) {
            throw new \InvalidArgumentException($comandanciaChoiceErrorMessage, __LINE__);
        }
        if (is_null($comandancia) || (is_array($comandancia) && empty($comandancia))) {
            unset($this->comandancia);
        } else {
            $this->comandancia = $comandancia;
        }
        return $this;
    }
    /**
     * Get ayuntamiento value
     * @return \StructType\Ayuntamiento|null
     */
    public function getAyuntamiento()
    {
        return isset($this->ayuntamiento) ? $this->ayuntamiento : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAyuntamiento method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAyuntamiento method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAyuntamientoForChoiceConstraintsFromSetAyuntamiento($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'dgp',
            'portico',
            'helicoptero',
            'convAyto',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ayuntamiento can\'t be set as the property %s is already set. Only one property must be set among these properties: ayuntamiento, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ayuntamiento value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ayuntamiento $ayuntamiento
     * @return \StructType\Denunciante
     */
    public function setAyuntamiento(\StructType\Ayuntamiento $ayuntamiento = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($ayuntamientoChoiceErrorMessage = self::validateAyuntamientoForChoiceConstraintsFromSetAyuntamiento($ayuntamiento))) {
            throw new \InvalidArgumentException($ayuntamientoChoiceErrorMessage, __LINE__);
        }
        if (is_null($ayuntamiento) || (is_array($ayuntamiento) && empty($ayuntamiento))) {
            unset($this->ayuntamiento);
        } else {
            $this->ayuntamiento = $ayuntamiento;
        }
        return $this;
    }
    /**
     * Get dgp value
     * @return string|null
     */
    public function getDgp()
    {
        return isset($this->dgp) ? $this->dgp : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDgp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDgp method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDgpForChoiceConstraintsFromSetDgp($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'ayuntamiento',
            'portico',
            'helicoptero',
            'convAyto',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dgp can\'t be set as the property %s is already set. Only one property must be set among these properties: dgp, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dgp value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dgp
     * @return \StructType\Denunciante
     */
    public function setDgp($dgp = null)
    {
        // validation for constraint: string
        if (!is_null($dgp) && !is_string($dgp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dgp, true), gettype($dgp)), __LINE__);
        }
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($dgpChoiceErrorMessage = self::validateDgpForChoiceConstraintsFromSetDgp($dgp))) {
            throw new \InvalidArgumentException($dgpChoiceErrorMessage, __LINE__);
        }
        if (is_null($dgp) || (is_array($dgp) && empty($dgp))) {
            unset($this->dgp);
        } else {
            $this->dgp = $dgp;
        }
        return $this;
    }
    /**
     * Get portico value
     * @return \StructType\Portico|null
     */
    public function getPortico()
    {
        return isset($this->portico) ? $this->portico : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPortico method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPortico method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePorticoForChoiceConstraintsFromSetPortico($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'ayuntamiento',
            'dgp',
            'helicoptero',
            'convAyto',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property portico can\'t be set as the property %s is already set. Only one property must be set among these properties: portico, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set portico value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Portico $portico
     * @return \StructType\Denunciante
     */
    public function setPortico(\StructType\Portico $portico = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($porticoChoiceErrorMessage = self::validatePorticoForChoiceConstraintsFromSetPortico($portico))) {
            throw new \InvalidArgumentException($porticoChoiceErrorMessage, __LINE__);
        }
        if (is_null($portico) || (is_array($portico) && empty($portico))) {
            unset($this->portico);
        } else {
            $this->portico = $portico;
        }
        return $this;
    }
    /**
     * Get helicoptero value
     * @return \StructType\Helicoptero|null
     */
    public function getHelicoptero()
    {
        return isset($this->helicoptero) ? $this->helicoptero : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHelicoptero method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHelicoptero method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHelicopteroForChoiceConstraintsFromSetHelicoptero($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'ayuntamiento',
            'dgp',
            'portico',
            'convAyto',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property helicoptero can\'t be set as the property %s is already set. Only one property must be set among these properties: helicoptero, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set helicoptero value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Helicoptero $helicoptero
     * @return \StructType\Denunciante
     */
    public function setHelicoptero(\StructType\Helicoptero $helicoptero = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($helicopteroChoiceErrorMessage = self::validateHelicopteroForChoiceConstraintsFromSetHelicoptero($helicoptero))) {
            throw new \InvalidArgumentException($helicopteroChoiceErrorMessage, __LINE__);
        }
        if (is_null($helicoptero) || (is_array($helicoptero) && empty($helicoptero))) {
            unset($this->helicoptero);
        } else {
            $this->helicoptero = $helicoptero;
        }
        return $this;
    }
    /**
     * Get convAyto value
     * @return \StructType\ConvAyto|null
     */
    public function getConvAyto()
    {
        return isset($this->convAyto) ? $this->convAyto : null;
    }
    /**
     * This method is responsible for validating the value passed to the setConvAyto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConvAyto method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateConvAytoForChoiceConstraintsFromSetConvAyto($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'ayuntamiento',
            'dgp',
            'portico',
            'helicoptero',
            'voluntaria',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property convAyto can\'t be set as the property %s is already set. Only one property must be set among these properties: convAyto, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set convAyto value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ConvAyto $convAyto
     * @return \StructType\Denunciante
     */
    public function setConvAyto(\StructType\ConvAyto $convAyto = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($convAytoChoiceErrorMessage = self::validateConvAytoForChoiceConstraintsFromSetConvAyto($convAyto))) {
            throw new \InvalidArgumentException($convAytoChoiceErrorMessage, __LINE__);
        }
        if (is_null($convAyto) || (is_array($convAyto) && empty($convAyto))) {
            unset($this->convAyto);
        } else {
            $this->convAyto = $convAyto;
        }
        return $this;
    }
    /**
     * Get voluntaria value
     * @return \StructType\Voluntaria|null
     */
    public function getVoluntaria()
    {
        return isset($this->voluntaria) ? $this->voluntaria : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoluntaria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoluntaria method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoluntariaForChoiceConstraintsFromSetVoluntaria($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'ayuntamiento',
            'dgp',
            'portico',
            'helicoptero',
            'convAyto',
            'dron',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property voluntaria can\'t be set as the property %s is already set. Only one property must be set among these properties: voluntaria, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set voluntaria value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Voluntaria $voluntaria
     * @return \StructType\Denunciante
     */
    public function setVoluntaria(\StructType\Voluntaria $voluntaria = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($voluntariaChoiceErrorMessage = self::validateVoluntariaForChoiceConstraintsFromSetVoluntaria($voluntaria))) {
            throw new \InvalidArgumentException($voluntariaChoiceErrorMessage, __LINE__);
        }
        if (is_null($voluntaria) || (is_array($voluntaria) && empty($voluntaria))) {
            unset($this->voluntaria);
        } else {
            $this->voluntaria = $voluntaria;
        }
        return $this;
    }
    /**
     * Get dron value
     * @return \StructType\Dron|null
     */
    public function getDron()
    {
        return isset($this->dron) ? $this->dron : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDron method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDron method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDronForChoiceConstraintsFromSetDron($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'atgc',
            'comandancia',
            'ayuntamiento',
            'dgp',
            'portico',
            'helicoptero',
            'convAyto',
            'voluntaria',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dron can\'t be set as the property %s is already set. Only one property must be set among these properties: dron, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dron value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Dron $dron
     * @return \StructType\Denunciante
     */
    public function setDron(\StructType\Dron $dron = null)
    {
        // validation for constraint: choice(atgc, comandancia, ayuntamiento, dgp, portico, helicoptero, convAyto, voluntaria, dron)
        if ('' !== ($dronChoiceErrorMessage = self::validateDronForChoiceConstraintsFromSetDron($dron))) {
            throw new \InvalidArgumentException($dronChoiceErrorMessage, __LINE__);
        }
        if (is_null($dron) || (is_array($dron) && empty($dron))) {
            unset($this->dron);
        } else {
            $this->dron = $dron;
        }
        return $this;
    }
}
