<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cinemometro StructType
 * @subpackage Structs
 */
class Cinemometro extends AbstractStructBase
{
    /**
     * The antena
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la antena.Ej: 39650
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $antena;
    /**
     * The cinemometro
     * Meta information extracted from the WSDL
     * - documentation: Modelo del cinemometro. Ej: RAI 2002
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cinemometro;
    /**
     * Constructor method for Cinemometro
     * @uses Cinemometro::setAntena()
     * @uses Cinemometro::setCinemometro()
     * @param string $antena
     * @param string $cinemometro
     */
    public function __construct($antena = null, $cinemometro = null)
    {
        $this
            ->setAntena($antena)
            ->setCinemometro($cinemometro);
    }
    /**
     * Get antena value
     * @return string
     */
    public function getAntena()
    {
        return $this->antena;
    }
    /**
     * Set antena value
     * @param string $antena
     * @return \StructType\Cinemometro
     */
    public function setAntena($antena = null)
    {
        // validation for constraint: string
        if (!is_null($antena) && !is_string($antena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antena, true), gettype($antena)), __LINE__);
        }
        $this->antena = $antena;
        return $this;
    }
    /**
     * Get cinemometro value
     * @return string
     */
    public function getCinemometro()
    {
        return $this->cinemometro;
    }
    /**
     * Set cinemometro value
     * @param string $cinemometro
     * @return \StructType\Cinemometro
     */
    public function setCinemometro($cinemometro = null)
    {
        // validation for constraint: string
        if (!is_null($cinemometro) && !is_string($cinemometro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cinemometro, true), gettype($cinemometro)), __LINE__);
        }
        $this->cinemometro = $cinemometro;
        return $this;
    }
}
