<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Alcoholimetro StructType
 * Meta information extracted from the WSDL
 * - documentation: Alcoholimetro utilizado en una sancion de alcoholemia
 * @subpackage Structs
 */
class Alcoholimetro extends AbstractStructBase
{
    /**
     * The numeroSerie
     * Meta information extracted from the WSDL
     * - documentation: Numero de serie del alcoholimetro utilizado en la prueba de alcoholemia en aire. Ej: 123
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $numeroSerie;
    /**
     * The marca
     * Meta information extracted from the WSDL
     * - documentation: Marca del alcoholimetro utilizado en la prueba de alcoholemia en aire. Ej: DRAGER
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $marca;
    /**
     * Constructor method for Alcoholimetro
     * @uses Alcoholimetro::setNumeroSerie()
     * @uses Alcoholimetro::setMarca()
     * @param string $numeroSerie
     * @param string $marca
     */
    public function __construct($numeroSerie = null, $marca = null)
    {
        $this
            ->setNumeroSerie($numeroSerie)
            ->setMarca($marca);
    }
    /**
     * Get numeroSerie value
     * @return string
     */
    public function getNumeroSerie()
    {
        return $this->numeroSerie;
    }
    /**
     * Set numeroSerie value
     * @param string $numeroSerie
     * @return \StructType\Alcoholimetro
     */
    public function setNumeroSerie($numeroSerie = null)
    {
        // validation for constraint: string
        if (!is_null($numeroSerie) && !is_string($numeroSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroSerie, true), gettype($numeroSerie)), __LINE__);
        }
        $this->numeroSerie = $numeroSerie;
        return $this;
    }
    /**
     * Get marca value
     * @return string|null
     */
    public function getMarca()
    {
        return $this->marca;
    }
    /**
     * Set marca value
     * @param string $marca
     * @return \StructType\Alcoholimetro
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marca, true), gettype($marca)), __LINE__);
        }
        $this->marca = $marca;
        return $this;
    }
}
