<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Alta ServiceType
 * @subpackage Services
 */
class Alta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named altaDenuncia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AltaDenunciaPeticion $altaDenunciaPeticion
     * @return \StructType\AltaDenunciaRespuesta|bool
     */
    public function altaDenuncia(\StructType\AltaDenunciaPeticion $altaDenunciaPeticion)
    {
        try {
            $this->setResult($this->getSoapClient()->altaDenuncia($altaDenunciaPeticion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named altaOficio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AltaOficioPeticion $altaOficioPeticion
     * @return \StructType\AltaOficioRespuesta|bool
     */
    public function altaOficio(\StructType\AltaOficioPeticion $altaOficioPeticion)
    {
        try {
            $this->setResult($this->getSoapClient()->altaOficio($altaOficioPeticion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AltaDenunciaRespuesta|\StructType\AltaOficioRespuesta
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
