<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetailContext StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetailContext
 * @subpackage Structs
 */
class RetailContext extends AbstractStructBase
{
    /**
     * The DatabaseId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatabaseId;
    /**
     * Constructor method for RetailContext
     * @uses RetailContext::setDatabaseId()
     * @param string $databaseId
     */
    public function __construct($databaseId = null)
    {
        $this
            ->setDatabaseId($databaseId);
    }
    /**
     * Get DatabaseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatabaseId()
    {
        return isset($this->DatabaseId) ? $this->DatabaseId : null;
    }
    /**
     * Set DatabaseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $databaseId
     * @return \Cegid\StructType\RetailContext
     */
    public function setDatabaseId($databaseId = null)
    {
        // validation for constraint: string
        if (!is_null($databaseId) && !is_string($databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseId, true), gettype($databaseId)), __LINE__);
        }
        if (is_null($databaseId) || (is_array($databaseId) && empty($databaseId))) {
            unset($this->DatabaseId);
        } else {
            $this->DatabaseId = $databaseId;
        }
        return $this;
    }
}
