<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplaceRequestHeaderOmniChannel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReplaceRequestHeaderOmniChannel
 * @subpackage Structs
 */
class ReplaceRequestHeaderOmniChannel extends AbstractStructBase
{
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * The ReturnType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnType;
    /**
     * Constructor method for ReplaceRequestHeaderOmniChannel
     * @uses ReplaceRequestHeaderOmniChannel::setPaymentType()
     * @uses ReplaceRequestHeaderOmniChannel::setReturnType()
     * @param string $paymentType
     * @param string $returnType
     */
    public function __construct($paymentType = null, $returnType = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setReturnType($returnType);
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Cegid\EnumType\PaymentType::valueIsValid()
     * @uses \Cegid\EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \Cegid\StructType\ReplaceRequestHeaderOmniChannel
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\PaymentType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \Cegid\EnumType\PaymentType::getValidValues())), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Get ReturnType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnType()
    {
        return isset($this->ReturnType) ? $this->ReturnType : null;
    }
    /**
     * Set ReturnType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Cegid\EnumType\ReturnType::valueIsValid()
     * @uses \Cegid\EnumType\ReturnType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $returnType
     * @return \Cegid\StructType\ReplaceRequestHeaderOmniChannel
     */
    public function setReturnType($returnType = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\ReturnType::valueIsValid($returnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\ReturnType', is_array($returnType) ? implode(', ', $returnType) : var_export($returnType, true), implode(', ', \Cegid\EnumType\ReturnType::getValidValues())), __LINE__);
        }
        if (is_null($returnType) || (is_array($returnType) && empty($returnType))) {
            unset($this->ReturnType);
        } else {
            $this->ReturnType = $returnType;
        }
        return $this;
    }
}
