<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplaceRequestHeaderEmployeeCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReplaceRequestHeaderEmployeeCollection
 * @subpackage Structs
 */
class ReplaceRequestHeaderEmployeeCollection extends AbstractStructBase
{
    /**
     * The Employee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ReplaceRequestHeaderEmployee[]
     */
    public $Employee;
    /**
     * Constructor method for ReplaceRequestHeaderEmployeeCollection
     * @uses ReplaceRequestHeaderEmployeeCollection::setEmployee()
     * @param \Cegid\StructType\ReplaceRequestHeaderEmployee[] $employee
     */
    public function __construct(array $employee = array())
    {
        $this
            ->setEmployee($employee);
    }
    /**
     * Get Employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ReplaceRequestHeaderEmployee[]|null
     */
    public function getEmployee()
    {
        return isset($this->Employee) ? $this->Employee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeForArrayConstraintsFromSetEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $replaceRequestHeaderEmployeeCollectionEmployeeItem) {
            // validation for constraint: itemType
            if (!$replaceRequestHeaderEmployeeCollectionEmployeeItem instanceof \Cegid\StructType\ReplaceRequestHeaderEmployee) {
                $invalidValues[] = is_object($replaceRequestHeaderEmployeeCollectionEmployeeItem) ? get_class($replaceRequestHeaderEmployeeCollectionEmployeeItem) : sprintf('%s(%s)', gettype($replaceRequestHeaderEmployeeCollectionEmployeeItem), var_export($replaceRequestHeaderEmployeeCollectionEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employee property can only contain items of type \Cegid\StructType\ReplaceRequestHeaderEmployee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\ReplaceRequestHeaderEmployee[] $employee
     * @return \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection
     */
    public function setEmployee(array $employee = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeArrayErrorMessage = self::validateEmployeeForArrayConstraintsFromSetEmployee($employee))) {
            throw new \InvalidArgumentException($employeeArrayErrorMessage, __LINE__);
        }
        if (is_null($employee) || (is_array($employee) && empty($employee))) {
            unset($this->Employee);
        } else {
            $this->Employee = $employee;
        }
        return $this;
    }
    /**
     * Add item to Employee value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\ReplaceRequestHeaderEmployee $item
     * @return \Cegid\StructType\ReplaceRequestHeaderEmployeeCollection
     */
    public function addToEmployee(\Cegid\StructType\ReplaceRequestHeaderEmployee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\ReplaceRequestHeaderEmployee) {
            throw new \InvalidArgumentException(sprintf('The Employee property can only contain items of type \Cegid\StructType\ReplaceRequestHeaderEmployee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employee[] = $item;
        return $this;
    }
}
