<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Paging StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Paging
 * @subpackage Structs
 */
class Paging extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PageSize;
    /**
     * Constructor method for Paging
     * @uses Paging::setPageIndex()
     * @uses Paging::setPageSize()
     * @param int $pageIndex
     * @param int $pageSize
     */
    public function __construct($pageIndex = null, $pageSize = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize);
    }
    /**
     * Get PageIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPageIndex()
    {
        return isset($this->PageIndex) ? $this->PageIndex : null;
    }
    /**
     * Set PageIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pageIndex
     * @return \Cegid\StructType\Paging
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        if (is_null($pageIndex) || (is_array($pageIndex) && empty($pageIndex))) {
            unset($this->PageIndex);
        } else {
            $this->PageIndex = $pageIndex;
        }
        return $this;
    }
    /**
     * Get PageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPageSize()
    {
        return isset($this->PageSize) ? $this->PageSize : null;
    }
    /**
     * Set PageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pageSize
     * @return \Cegid\StructType\Paging
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        if (is_null($pageSize) || (is_array($pageSize) && empty($pageSize))) {
            unset($this->PageSize);
        } else {
            $this->PageSize = $pageSize;
        }
        return $this;
    }
}
