<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListDetailRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetListDetailRequest
 * @subpackage Structs
 */
class GetListDetailRequest extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderCancelStatusSELWU3Qp
     */
    public $CancelStatus;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerId;
    /**
     * The DocumentType
     * @var string
     */
    public $DocumentType;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The ExtractByOldest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExtractByOldest;
    /**
     * The Fields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfFieldsType
     */
    public $Fields;
    /**
     * The InternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalReference;
    /**
     * The OmniChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\GetListDetailRequestOmniChannel
     */
    public $OmniChannel;
    /**
     * The Paging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\Paging
     */
    public $Paging;
    /**
     * The SearchDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\GetListDetailRequestSearchDate
     */
    public $SearchDate;
    /**
     * The StoreId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StoreId;
    /**
     * The VisaStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderVisaStatusSELWU3Qp
     */
    public $VisaStatus;
    /**
     * Constructor method for GetListDetailRequest
     * @uses GetListDetailRequest::setActive()
     * @uses GetListDetailRequest::setCancelStatus()
     * @uses GetListDetailRequest::setCustomerId()
     * @uses GetListDetailRequest::setDocumentType()
     * @uses GetListDetailRequest::setExternalReference()
     * @uses GetListDetailRequest::setExtractByOldest()
     * @uses GetListDetailRequest::setFields()
     * @uses GetListDetailRequest::setInternalReference()
     * @uses GetListDetailRequest::setOmniChannel()
     * @uses GetListDetailRequest::setPaging()
     * @uses GetListDetailRequest::setSearchDate()
     * @uses GetListDetailRequest::setStoreId()
     * @uses GetListDetailRequest::setVisaStatus()
     * @param bool $active
     * @param \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderCancelStatusSELWU3Qp $cancelStatus
     * @param string $customerId
     * @param string $documentType
     * @param string $externalReference
     * @param bool $extractByOldest
     * @param \Cegid\ArrayType\ArrayOfFieldsType $fields
     * @param string $internalReference
     * @param \Cegid\StructType\GetListDetailRequestOmniChannel $omniChannel
     * @param \Cegid\StructType\Paging $paging
     * @param \Cegid\StructType\GetListDetailRequestSearchDate $searchDate
     * @param string $storeId
     * @param \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderVisaStatusSELWU3Qp $visaStatus
     */
    public function __construct($active = null, \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderCancelStatusSELWU3Qp $cancelStatus = null, $customerId = null, $documentType = null, $externalReference = null, $extractByOldest = null, \Cegid\ArrayType\ArrayOfFieldsType $fields = null, $internalReference = null, \Cegid\StructType\GetListDetailRequestOmniChannel $omniChannel = null, \Cegid\StructType\Paging $paging = null, \Cegid\StructType\GetListDetailRequestSearchDate $searchDate = null, $storeId = null, \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderVisaStatusSELWU3Qp $visaStatus = null)
    {
        $this
            ->setActive($active)
            ->setCancelStatus($cancelStatus)
            ->setCustomerId($customerId)
            ->setDocumentType($documentType)
            ->setExternalReference($externalReference)
            ->setExtractByOldest($extractByOldest)
            ->setFields($fields)
            ->setInternalReference($internalReference)
            ->setOmniChannel($omniChannel)
            ->setPaging($paging)
            ->setSearchDate($searchDate)
            ->setStoreId($storeId)
            ->setVisaStatus($visaStatus);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get CancelStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderCancelStatusSELWU3Qp|null
     */
    public function getCancelStatus()
    {
        return isset($this->CancelStatus) ? $this->CancelStatus : null;
    }
    /**
     * Set CancelStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderCancelStatusSELWU3Qp $cancelStatus
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setCancelStatus(\Cegid\ArrayType\ArrayOfNullableOfCustomerOrderCancelStatusSELWU3Qp $cancelStatus = null)
    {
        if (is_null($cancelStatus) || (is_array($cancelStatus) && empty($cancelStatus))) {
            unset($this->CancelStatus);
        } else {
            $this->CancelStatus = $cancelStatus;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeGet::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeGet::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDocumentTypeGet::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDocumentTypeGet', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \Cegid\EnumType\CustomerOrderDocumentTypeGet::getValidValues())), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get ExtractByOldest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExtractByOldest()
    {
        return isset($this->ExtractByOldest) ? $this->ExtractByOldest : null;
    }
    /**
     * Set ExtractByOldest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $extractByOldest
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setExtractByOldest($extractByOldest = null)
    {
        // validation for constraint: boolean
        if (!is_null($extractByOldest) && !is_bool($extractByOldest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extractByOldest, true), gettype($extractByOldest)), __LINE__);
        }
        if (is_null($extractByOldest) || (is_array($extractByOldest) && empty($extractByOldest))) {
            unset($this->ExtractByOldest);
        } else {
            $this->ExtractByOldest = $extractByOldest;
        }
        return $this;
    }
    /**
     * Get Fields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfFieldsType|null
     */
    public function getFields()
    {
        return isset($this->Fields) ? $this->Fields : null;
    }
    /**
     * Set Fields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfFieldsType $fields
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setFields(\Cegid\ArrayType\ArrayOfFieldsType $fields = null)
    {
        if (is_null($fields) || (is_array($fields) && empty($fields))) {
            unset($this->Fields);
        } else {
            $this->Fields = $fields;
        }
        return $this;
    }
    /**
     * Get InternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalReference()
    {
        return isset($this->InternalReference) ? $this->InternalReference : null;
    }
    /**
     * Set InternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalReference
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setInternalReference($internalReference = null)
    {
        // validation for constraint: string
        if (!is_null($internalReference) && !is_string($internalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalReference, true), gettype($internalReference)), __LINE__);
        }
        if (is_null($internalReference) || (is_array($internalReference) && empty($internalReference))) {
            unset($this->InternalReference);
        } else {
            $this->InternalReference = $internalReference;
        }
        return $this;
    }
    /**
     * Get OmniChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\GetListDetailRequestOmniChannel|null
     */
    public function getOmniChannel()
    {
        return isset($this->OmniChannel) ? $this->OmniChannel : null;
    }
    /**
     * Set OmniChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\GetListDetailRequestOmniChannel $omniChannel
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setOmniChannel(\Cegid\StructType\GetListDetailRequestOmniChannel $omniChannel = null)
    {
        if (is_null($omniChannel) || (is_array($omniChannel) && empty($omniChannel))) {
            unset($this->OmniChannel);
        } else {
            $this->OmniChannel = $omniChannel;
        }
        return $this;
    }
    /**
     * Get Paging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\Paging|null
     */
    public function getPaging()
    {
        return isset($this->Paging) ? $this->Paging : null;
    }
    /**
     * Set Paging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\Paging $paging
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setPaging(\Cegid\StructType\Paging $paging = null)
    {
        if (is_null($paging) || (is_array($paging) && empty($paging))) {
            unset($this->Paging);
        } else {
            $this->Paging = $paging;
        }
        return $this;
    }
    /**
     * Get SearchDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\GetListDetailRequestSearchDate|null
     */
    public function getSearchDate()
    {
        return isset($this->SearchDate) ? $this->SearchDate : null;
    }
    /**
     * Set SearchDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\GetListDetailRequestSearchDate $searchDate
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setSearchDate(\Cegid\StructType\GetListDetailRequestSearchDate $searchDate = null)
    {
        if (is_null($searchDate) || (is_array($searchDate) && empty($searchDate))) {
            unset($this->SearchDate);
        } else {
            $this->SearchDate = $searchDate;
        }
        return $this;
    }
    /**
     * Get StoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStoreId()
    {
        return isset($this->StoreId) ? $this->StoreId : null;
    }
    /**
     * Set StoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $storeId
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: string
        if (!is_null($storeId) && !is_string($storeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        if (is_null($storeId) || (is_array($storeId) && empty($storeId))) {
            unset($this->StoreId);
        } else {
            $this->StoreId = $storeId;
        }
        return $this;
    }
    /**
     * Get VisaStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderVisaStatusSELWU3Qp|null
     */
    public function getVisaStatus()
    {
        return isset($this->VisaStatus) ? $this->VisaStatus : null;
    }
    /**
     * Set VisaStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfNullableOfCustomerOrderVisaStatusSELWU3Qp $visaStatus
     * @return \Cegid\StructType\GetListDetailRequest
     */
    public function setVisaStatus(\Cegid\ArrayType\ArrayOfNullableOfCustomerOrderVisaStatusSELWU3Qp $visaStatus = null)
    {
        if (is_null($visaStatus) || (is_array($visaStatus) && empty($visaStatus))) {
            unset($this->VisaStatus);
        } else {
            $this->VisaStatus = $visaStatus;
        }
        return $this;
    }
}
