<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionDetail
 * @subpackage Structs
 */
class ExceptionDetail extends AbstractStructBase
{
    /**
     * The HelpLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HelpLink;
    /**
     * The InnerException
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\ExceptionDetail
     */
    public $InnerException;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The StackTrace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * The TrackingId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TrackingId;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ExceptionDetail
     * @uses ExceptionDetail::setHelpLink()
     * @uses ExceptionDetail::setInnerException()
     * @uses ExceptionDetail::setMessage()
     * @uses ExceptionDetail::setStackTrace()
     * @uses ExceptionDetail::setTrackingId()
     * @uses ExceptionDetail::setType()
     * @param string $helpLink
     * @param \Cegid\StructType\ExceptionDetail $innerException
     * @param string $message
     * @param string $stackTrace
     * @param string $trackingId
     * @param string $type
     */
    public function __construct($helpLink = null, \Cegid\StructType\ExceptionDetail $innerException = null, $message = null, $stackTrace = null, $trackingId = null, $type = null)
    {
        $this
            ->setHelpLink($helpLink)
            ->setInnerException($innerException)
            ->setMessage($message)
            ->setStackTrace($stackTrace)
            ->setTrackingId($trackingId)
            ->setType($type);
    }
    /**
     * Get HelpLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHelpLink()
    {
        return isset($this->HelpLink) ? $this->HelpLink : null;
    }
    /**
     * Set HelpLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $helpLink
     * @return \Cegid\StructType\ExceptionDetail
     */
    public function setHelpLink($helpLink = null)
    {
        // validation for constraint: string
        if (!is_null($helpLink) && !is_string($helpLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($helpLink, true), gettype($helpLink)), __LINE__);
        }
        if (is_null($helpLink) || (is_array($helpLink) && empty($helpLink))) {
            unset($this->HelpLink);
        } else {
            $this->HelpLink = $helpLink;
        }
        return $this;
    }
    /**
     * Get InnerException value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\ExceptionDetail|null
     */
    public function getInnerException()
    {
        return isset($this->InnerException) ? $this->InnerException : null;
    }
    /**
     * Set InnerException value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\ExceptionDetail $innerException
     * @return \Cegid\StructType\ExceptionDetail
     */
    public function setInnerException(\Cegid\StructType\ExceptionDetail $innerException = null)
    {
        if (is_null($innerException) || (is_array($innerException) && empty($innerException))) {
            unset($this->InnerException);
        } else {
            $this->InnerException = $innerException;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \Cegid\StructType\ExceptionDetail
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \Cegid\StructType\ExceptionDetail
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTrace, true), gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Get TrackingId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingId()
    {
        return isset($this->TrackingId) ? $this->TrackingId : null;
    }
    /**
     * Set TrackingId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingId
     * @return \Cegid\StructType\ExceptionDetail
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingId, true), gettype($trackingId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($trackingId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($trackingId, true)), __LINE__);
        }
        if (is_null($trackingId) || (is_array($trackingId) && empty($trackingId))) {
            unset($this->TrackingId);
        } else {
            $this->TrackingId = $trackingId;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \Cegid\StructType\ExceptionDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
