<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentAmountTotal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentAmountTotal
 * @subpackage Structs
 */
class DocumentAmountTotal extends AbstractStructBase
{
    /**
     * The NetAmount
     * @var float
     */
    public $NetAmount;
    /**
     * Constructor method for DocumentAmountTotal
     * @uses DocumentAmountTotal::setNetAmount()
     * @param float $netAmount
     */
    public function __construct($netAmount = null)
    {
        $this
            ->setNetAmount($netAmount);
    }
    /**
     * Get NetAmount value
     * @return float|null
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param float $netAmount
     * @return \Cegid\StructType\DocumentAmountTotal
     */
    public function setNetAmount($netAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netAmount) && !(is_float($netAmount) || is_numeric($netAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmount, true), gettype($netAmount)), __LINE__);
        }
        $this->NetAmount = $netAmount;
        return $this;
    }
}
