<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineTax StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineTax
 * @subpackage Structs
 */
class CustomerOrderLineTax extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CategoryId;
    /**
     * The Rank
     * @var int
     */
    public $Rank;
    /**
     * The TaxModelId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxModelId;
    /**
     * The TaxSystemId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxSystemId;
    /**
     * The TaxationCountryId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxationCountryId;
    /**
     * The TaxationRegionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxationRegionId;
    /**
     * Constructor method for CustomerOrderLineTax
     * @uses CustomerOrderLineTax::setAmount()
     * @uses CustomerOrderLineTax::setCategoryId()
     * @uses CustomerOrderLineTax::setRank()
     * @uses CustomerOrderLineTax::setTaxModelId()
     * @uses CustomerOrderLineTax::setTaxSystemId()
     * @uses CustomerOrderLineTax::setTaxationCountryId()
     * @uses CustomerOrderLineTax::setTaxationRegionId()
     * @param float $amount
     * @param string $categoryId
     * @param int $rank
     * @param string $taxModelId
     * @param string $taxSystemId
     * @param string $taxationCountryId
     * @param string $taxationRegionId
     */
    public function __construct($amount = null, $categoryId = null, $rank = null, $taxModelId = null, $taxSystemId = null, $taxationCountryId = null, $taxationRegionId = null)
    {
        $this
            ->setAmount($amount)
            ->setCategoryId($categoryId)
            ->setRank($rank)
            ->setTaxModelId($taxModelId)
            ->setTaxSystemId($taxSystemId)
            ->setTaxationCountryId($taxationCountryId)
            ->setTaxationRegionId($taxationRegionId);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get Rank value
     * @return int|null
     */
    public function getRank()
    {
        return $this->Rank;
    }
    /**
     * Set Rank value
     * @param int $rank
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setRank($rank = null)
    {
        // validation for constraint: int
        if (!is_null($rank) && !(is_int($rank) || ctype_digit($rank))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rank, true), gettype($rank)), __LINE__);
        }
        $this->Rank = $rank;
        return $this;
    }
    /**
     * Get TaxModelId value
     * @return string|null
     */
    public function getTaxModelId()
    {
        return $this->TaxModelId;
    }
    /**
     * Set TaxModelId value
     * @param string $taxModelId
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setTaxModelId($taxModelId = null)
    {
        // validation for constraint: string
        if (!is_null($taxModelId) && !is_string($taxModelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxModelId, true), gettype($taxModelId)), __LINE__);
        }
        $this->TaxModelId = $taxModelId;
        return $this;
    }
    /**
     * Get TaxSystemId value
     * @return string|null
     */
    public function getTaxSystemId()
    {
        return $this->TaxSystemId;
    }
    /**
     * Set TaxSystemId value
     * @param string $taxSystemId
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setTaxSystemId($taxSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($taxSystemId) && !is_string($taxSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxSystemId, true), gettype($taxSystemId)), __LINE__);
        }
        $this->TaxSystemId = $taxSystemId;
        return $this;
    }
    /**
     * Get TaxationCountryId value
     * @return string|null
     */
    public function getTaxationCountryId()
    {
        return $this->TaxationCountryId;
    }
    /**
     * Set TaxationCountryId value
     * @param string $taxationCountryId
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setTaxationCountryId($taxationCountryId = null)
    {
        // validation for constraint: string
        if (!is_null($taxationCountryId) && !is_string($taxationCountryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxationCountryId, true), gettype($taxationCountryId)), __LINE__);
        }
        $this->TaxationCountryId = $taxationCountryId;
        return $this;
    }
    /**
     * Get TaxationRegionId value
     * @return string|null
     */
    public function getTaxationRegionId()
    {
        return $this->TaxationRegionId;
    }
    /**
     * Set TaxationRegionId value
     * @param string $taxationRegionId
     * @return \Cegid\StructType\CustomerOrderLineTax
     */
    public function setTaxationRegionId($taxationRegionId = null)
    {
        // validation for constraint: string
        if (!is_null($taxationRegionId) && !is_string($taxationRegionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxationRegionId, true), gettype($taxationRegionId)), __LINE__);
        }
        $this->TaxationRegionId = $taxationRegionId;
        return $this;
    }
}
