<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineLinkedDocumentKey StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineLinkedDocumentKey
 * @subpackage Structs
 */
class CustomerOrderLineLinkedDocumentKey extends AbstractStructBase
{
    /**
     * The LineId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LineId;
    /**
     * The Number
     * @var int
     */
    public $Number;
    /**
     * The Stub
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Stub;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for CustomerOrderLineLinkedDocumentKey
     * @uses CustomerOrderLineLinkedDocumentKey::setLineId()
     * @uses CustomerOrderLineLinkedDocumentKey::setNumber()
     * @uses CustomerOrderLineLinkedDocumentKey::setStub()
     * @uses CustomerOrderLineLinkedDocumentKey::setType()
     * @param int $lineId
     * @param int $number
     * @param string $stub
     * @param string $type
     */
    public function __construct($lineId = null, $number = null, $stub = null, $type = null)
    {
        $this
            ->setLineId($lineId)
            ->setNumber($number)
            ->setStub($stub)
            ->setType($type);
    }
    /**
     * Get LineId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLineId()
    {
        return isset($this->LineId) ? $this->LineId : null;
    }
    /**
     * Set LineId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lineId
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentKey
     */
    public function setLineId($lineId = null)
    {
        // validation for constraint: int
        if (!is_null($lineId) && !(is_int($lineId) || ctype_digit($lineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineId, true), gettype($lineId)), __LINE__);
        }
        if (is_null($lineId) || (is_array($lineId) && empty($lineId))) {
            unset($this->LineId);
        } else {
            $this->LineId = $lineId;
        }
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentKey
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Stub value
     * @return string|null
     */
    public function getStub()
    {
        return $this->Stub;
    }
    /**
     * Set Stub value
     * @param string $stub
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentKey
     */
    public function setStub($stub = null)
    {
        // validation for constraint: string
        if (!is_null($stub) && !is_string($stub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stub, true), gettype($stub)), __LINE__);
        }
        $this->Stub = $stub;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeSales::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeSales::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\CustomerOrderLineLinkedDocumentKey
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDocumentTypeSales::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDocumentTypeSales', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\CustomerOrderDocumentTypeSales::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
