<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderLineDiscount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderLineDiscount
 * @subpackage Structs
 */
class CustomerOrderLineDiscount extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The MarkdownReasonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarkdownReasonId;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for CustomerOrderLineDiscount
     * @uses CustomerOrderLineDiscount::setAmount()
     * @uses CustomerOrderLineDiscount::setMarkdownReasonId()
     * @uses CustomerOrderLineDiscount::setType()
     * @param float $amount
     * @param string $markdownReasonId
     * @param string $type
     */
    public function __construct($amount = null, $markdownReasonId = null, $type = null)
    {
        $this
            ->setAmount($amount)
            ->setMarkdownReasonId($markdownReasonId)
            ->setType($type);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Cegid\StructType\CustomerOrderLineDiscount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get MarkdownReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarkdownReasonId()
    {
        return isset($this->MarkdownReasonId) ? $this->MarkdownReasonId : null;
    }
    /**
     * Set MarkdownReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $markdownReasonId
     * @return \Cegid\StructType\CustomerOrderLineDiscount
     */
    public function setMarkdownReasonId($markdownReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($markdownReasonId) && !is_string($markdownReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markdownReasonId, true), gettype($markdownReasonId)), __LINE__);
        }
        if (is_null($markdownReasonId) || (is_array($markdownReasonId) && empty($markdownReasonId))) {
            unset($this->MarkdownReasonId);
        } else {
            $this->MarkdownReasonId = $markdownReasonId;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Cegid\EnumType\DiscountTypology::valueIsValid()
     * @uses \Cegid\EnumType\DiscountTypology::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\CustomerOrderLineDiscount
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\DiscountTypology::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\DiscountTypology', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\DiscountTypology::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
