<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerOrderHeaderCustomerEmailCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerOrderHeaderCustomerEmailCollection
 * @subpackage Structs
 */
class CustomerOrderHeaderCustomerEmailCollection extends AbstractStructBase
{
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CustomerOrderHeaderCustomerEmail[]
     */
    public $Email;
    /**
     * Constructor method for CustomerOrderHeaderCustomerEmailCollection
     * @uses CustomerOrderHeaderCustomerEmailCollection::setEmail()
     * @param \Cegid\StructType\CustomerOrderHeaderCustomerEmail[] $email
     */
    public function __construct(array $email = array())
    {
        $this
            ->setEmail($email);
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CustomerOrderHeaderCustomerEmail[]|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerOrderHeaderCustomerEmailCollectionEmailItem) {
            // validation for constraint: itemType
            if (!$customerOrderHeaderCustomerEmailCollectionEmailItem instanceof \Cegid\StructType\CustomerOrderHeaderCustomerEmail) {
                $invalidValues[] = is_object($customerOrderHeaderCustomerEmailCollectionEmailItem) ? get_class($customerOrderHeaderCustomerEmailCollectionEmailItem) : sprintf('%s(%s)', gettype($customerOrderHeaderCustomerEmailCollectionEmailItem), var_export($customerOrderHeaderCustomerEmailCollectionEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \Cegid\StructType\CustomerOrderHeaderCustomerEmail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrderHeaderCustomerEmail[] $email
     * @return \Cegid\StructType\CustomerOrderHeaderCustomerEmailCollection
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \Cegid\StructType\CustomerOrderHeaderCustomerEmail $item
     * @return \Cegid\StructType\CustomerOrderHeaderCustomerEmailCollection
     */
    public function addToEmail(\Cegid\StructType\CustomerOrderHeaderCustomerEmail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cegid\StructType\CustomerOrderHeaderCustomerEmail) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \Cegid\StructType\CustomerOrderHeaderCustomerEmail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
}
