<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestLineProductTax StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestLineProductTax
 * @subpackage Structs
 */
class CreateRequestLineProductTax extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Base
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Base;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CategoryId;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Percent;
    /**
     * The Rank
     * @var int
     */
    public $Rank;
    /**
     * The TaxCountryId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxCountryId;
    /**
     * The TaxExceptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExceptionId;
    /**
     * The TaxModelId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxModelId;
    /**
     * The TaxRegionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxRegionId;
    /**
     * The TaxSystemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxSystemId;
    /**
     * Constructor method for CreateRequestLineProductTax
     * @uses CreateRequestLineProductTax::setAmount()
     * @uses CreateRequestLineProductTax::setBase()
     * @uses CreateRequestLineProductTax::setCategoryId()
     * @uses CreateRequestLineProductTax::setPercent()
     * @uses CreateRequestLineProductTax::setRank()
     * @uses CreateRequestLineProductTax::setTaxCountryId()
     * @uses CreateRequestLineProductTax::setTaxExceptionId()
     * @uses CreateRequestLineProductTax::setTaxModelId()
     * @uses CreateRequestLineProductTax::setTaxRegionId()
     * @uses CreateRequestLineProductTax::setTaxSystemId()
     * @param float $amount
     * @param float $base
     * @param string $categoryId
     * @param float $percent
     * @param int $rank
     * @param string $taxCountryId
     * @param string $taxExceptionId
     * @param string $taxModelId
     * @param string $taxRegionId
     * @param string $taxSystemId
     */
    public function __construct($amount = null, $base = null, $categoryId = null, $percent = null, $rank = null, $taxCountryId = null, $taxExceptionId = null, $taxModelId = null, $taxRegionId = null, $taxSystemId = null)
    {
        $this
            ->setAmount($amount)
            ->setBase($base)
            ->setCategoryId($categoryId)
            ->setPercent($percent)
            ->setRank($rank)
            ->setTaxCountryId($taxCountryId)
            ->setTaxExceptionId($taxExceptionId)
            ->setTaxModelId($taxModelId)
            ->setTaxRegionId($taxRegionId)
            ->setTaxSystemId($taxSystemId);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Base value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBase()
    {
        return isset($this->Base) ? $this->Base : null;
    }
    /**
     * Set Base value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $base
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setBase($base = null)
    {
        // validation for constraint: float
        if (!is_null($base) && !(is_float($base) || is_numeric($base))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($base, true), gettype($base)), __LINE__);
        }
        if (is_null($base) || (is_array($base) && empty($base))) {
            unset($this->Base);
        } else {
            $this->Base = $base;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get Percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPercent()
    {
        return isset($this->Percent) ? $this->Percent : null;
    }
    /**
     * Set Percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $percent
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        if (is_null($percent) || (is_array($percent) && empty($percent))) {
            unset($this->Percent);
        } else {
            $this->Percent = $percent;
        }
        return $this;
    }
    /**
     * Get Rank value
     * @return int|null
     */
    public function getRank()
    {
        return $this->Rank;
    }
    /**
     * Set Rank value
     * @param int $rank
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setRank($rank = null)
    {
        // validation for constraint: int
        if (!is_null($rank) && !(is_int($rank) || ctype_digit($rank))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rank, true), gettype($rank)), __LINE__);
        }
        $this->Rank = $rank;
        return $this;
    }
    /**
     * Get TaxCountryId value
     * @return string|null
     */
    public function getTaxCountryId()
    {
        return $this->TaxCountryId;
    }
    /**
     * Set TaxCountryId value
     * @param string $taxCountryId
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setTaxCountryId($taxCountryId = null)
    {
        // validation for constraint: string
        if (!is_null($taxCountryId) && !is_string($taxCountryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCountryId, true), gettype($taxCountryId)), __LINE__);
        }
        $this->TaxCountryId = $taxCountryId;
        return $this;
    }
    /**
     * Get TaxExceptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExceptionId()
    {
        return isset($this->TaxExceptionId) ? $this->TaxExceptionId : null;
    }
    /**
     * Set TaxExceptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExceptionId
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setTaxExceptionId($taxExceptionId = null)
    {
        // validation for constraint: string
        if (!is_null($taxExceptionId) && !is_string($taxExceptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExceptionId, true), gettype($taxExceptionId)), __LINE__);
        }
        if (is_null($taxExceptionId) || (is_array($taxExceptionId) && empty($taxExceptionId))) {
            unset($this->TaxExceptionId);
        } else {
            $this->TaxExceptionId = $taxExceptionId;
        }
        return $this;
    }
    /**
     * Get TaxModelId value
     * @return string|null
     */
    public function getTaxModelId()
    {
        return $this->TaxModelId;
    }
    /**
     * Set TaxModelId value
     * @param string $taxModelId
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setTaxModelId($taxModelId = null)
    {
        // validation for constraint: string
        if (!is_null($taxModelId) && !is_string($taxModelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxModelId, true), gettype($taxModelId)), __LINE__);
        }
        $this->TaxModelId = $taxModelId;
        return $this;
    }
    /**
     * Get TaxRegionId value
     * @return string|null
     */
    public function getTaxRegionId()
    {
        return $this->TaxRegionId;
    }
    /**
     * Set TaxRegionId value
     * @param string $taxRegionId
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setTaxRegionId($taxRegionId = null)
    {
        // validation for constraint: string
        if (!is_null($taxRegionId) && !is_string($taxRegionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRegionId, true), gettype($taxRegionId)), __LINE__);
        }
        $this->TaxRegionId = $taxRegionId;
        return $this;
    }
    /**
     * Get TaxSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxSystemId()
    {
        return isset($this->TaxSystemId) ? $this->TaxSystemId : null;
    }
    /**
     * Set TaxSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxSystemId
     * @return \Cegid\StructType\CreateRequestLineProductTax
     */
    public function setTaxSystemId($taxSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($taxSystemId) && !is_string($taxSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxSystemId, true), gettype($taxSystemId)), __LINE__);
        }
        if (is_null($taxSystemId) || (is_array($taxSystemId) && empty($taxSystemId))) {
            unset($this->TaxSystemId);
        } else {
            $this->TaxSystemId = $taxSystemId;
        }
        return $this;
    }
}
