<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRequestLineProductDiscount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRequestLineProductDiscount
 * @subpackage Structs
 */
class CreateRequestLineProductDiscount extends AbstractStructBase
{
    /**
     * The BaseAmount
     * @var float
     */
    public $BaseAmount;
    /**
     * The ExcludedTaxAmount
     * @var float
     */
    public $ExcludedTaxAmount;
    /**
     * The ExternalPromotion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalPromotion;
    /**
     * The IncludedTaxAmount
     * @var float
     */
    public $IncludedTaxAmount;
    /**
     * The MarkdownReasonId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarkdownReasonId;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for CreateRequestLineProductDiscount
     * @uses CreateRequestLineProductDiscount::setBaseAmount()
     * @uses CreateRequestLineProductDiscount::setExcludedTaxAmount()
     * @uses CreateRequestLineProductDiscount::setExternalPromotion()
     * @uses CreateRequestLineProductDiscount::setIncludedTaxAmount()
     * @uses CreateRequestLineProductDiscount::setMarkdownReasonId()
     * @uses CreateRequestLineProductDiscount::setType()
     * @param float $baseAmount
     * @param float $excludedTaxAmount
     * @param string $externalPromotion
     * @param float $includedTaxAmount
     * @param string $markdownReasonId
     * @param string $type
     */
    public function __construct($baseAmount = null, $excludedTaxAmount = null, $externalPromotion = null, $includedTaxAmount = null, $markdownReasonId = null, $type = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setExcludedTaxAmount($excludedTaxAmount)
            ->setExternalPromotion($externalPromotion)
            ->setIncludedTaxAmount($includedTaxAmount)
            ->setMarkdownReasonId($markdownReasonId)
            ->setType($type);
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \Cegid\StructType\CreateRequestLineProductDiscount
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get ExcludedTaxAmount value
     * @return float|null
     */
    public function getExcludedTaxAmount()
    {
        return $this->ExcludedTaxAmount;
    }
    /**
     * Set ExcludedTaxAmount value
     * @param float $excludedTaxAmount
     * @return \Cegid\StructType\CreateRequestLineProductDiscount
     */
    public function setExcludedTaxAmount($excludedTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($excludedTaxAmount) && !(is_float($excludedTaxAmount) || is_numeric($excludedTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($excludedTaxAmount, true), gettype($excludedTaxAmount)), __LINE__);
        }
        $this->ExcludedTaxAmount = $excludedTaxAmount;
        return $this;
    }
    /**
     * Get ExternalPromotion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalPromotion()
    {
        return isset($this->ExternalPromotion) ? $this->ExternalPromotion : null;
    }
    /**
     * Set ExternalPromotion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalPromotion
     * @return \Cegid\StructType\CreateRequestLineProductDiscount
     */
    public function setExternalPromotion($externalPromotion = null)
    {
        // validation for constraint: string
        if (!is_null($externalPromotion) && !is_string($externalPromotion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPromotion, true), gettype($externalPromotion)), __LINE__);
        }
        if (is_null($externalPromotion) || (is_array($externalPromotion) && empty($externalPromotion))) {
            unset($this->ExternalPromotion);
        } else {
            $this->ExternalPromotion = $externalPromotion;
        }
        return $this;
    }
    /**
     * Get IncludedTaxAmount value
     * @return float|null
     */
    public function getIncludedTaxAmount()
    {
        return $this->IncludedTaxAmount;
    }
    /**
     * Set IncludedTaxAmount value
     * @param float $includedTaxAmount
     * @return \Cegid\StructType\CreateRequestLineProductDiscount
     */
    public function setIncludedTaxAmount($includedTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($includedTaxAmount) && !(is_float($includedTaxAmount) || is_numeric($includedTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($includedTaxAmount, true), gettype($includedTaxAmount)), __LINE__);
        }
        $this->IncludedTaxAmount = $includedTaxAmount;
        return $this;
    }
    /**
     * Get MarkdownReasonId value
     * @return string|null
     */
    public function getMarkdownReasonId()
    {
        return $this->MarkdownReasonId;
    }
    /**
     * Set MarkdownReasonId value
     * @param string $markdownReasonId
     * @return \Cegid\StructType\CreateRequestLineProductDiscount
     */
    public function setMarkdownReasonId($markdownReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($markdownReasonId) && !is_string($markdownReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markdownReasonId, true), gettype($markdownReasonId)), __LINE__);
        }
        $this->MarkdownReasonId = $markdownReasonId;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Cegid\EnumType\DiscountType::valueIsValid()
     * @uses \Cegid\EnumType\DiscountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\CreateRequestLineProductDiscount
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\DiscountType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\DiscountType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\DiscountType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
