<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestPayment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestPayment
 * @subpackage Structs
 */
class CreateFromRequestPayment extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestPaymentCreditCard
     */
    public $CreditCard;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyId;
    /**
     * The DueDate
     * @var string
     */
    public $DueDate;
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The MethodId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MethodId;
    /**
     * The ReceivedPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\CreateFromRequestPaymentReceivedPayment
     */
    public $ReceivedPayment;
    /**
     * The VoucherId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherId;
    /**
     * Constructor method for CreateFromRequestPayment
     * @uses CreateFromRequestPayment::setAmount()
     * @uses CreateFromRequestPayment::setCreditCard()
     * @uses CreateFromRequestPayment::setCurrencyId()
     * @uses CreateFromRequestPayment::setDueDate()
     * @uses CreateFromRequestPayment::setId()
     * @uses CreateFromRequestPayment::setMethodId()
     * @uses CreateFromRequestPayment::setReceivedPayment()
     * @uses CreateFromRequestPayment::setVoucherId()
     * @param float $amount
     * @param \Cegid\StructType\CreateFromRequestPaymentCreditCard $creditCard
     * @param string $currencyId
     * @param string $dueDate
     * @param int $id
     * @param string $methodId
     * @param \Cegid\StructType\CreateFromRequestPaymentReceivedPayment $receivedPayment
     * @param string $voucherId
     */
    public function __construct($amount = null, \Cegid\StructType\CreateFromRequestPaymentCreditCard $creditCard = null, $currencyId = null, $dueDate = null, $id = null, $methodId = null, \Cegid\StructType\CreateFromRequestPaymentReceivedPayment $receivedPayment = null, $voucherId = null)
    {
        $this
            ->setAmount($amount)
            ->setCreditCard($creditCard)
            ->setCurrencyId($currencyId)
            ->setDueDate($dueDate)
            ->setId($id)
            ->setMethodId($methodId)
            ->setReceivedPayment($receivedPayment)
            ->setVoucherId($voucherId);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CreditCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestPaymentCreditCard|null
     */
    public function getCreditCard()
    {
        return isset($this->CreditCard) ? $this->CreditCard : null;
    }
    /**
     * Set CreditCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestPaymentCreditCard $creditCard
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setCreditCard(\Cegid\StructType\CreateFromRequestPaymentCreditCard $creditCard = null)
    {
        if (is_null($creditCard) || (is_array($creditCard) && empty($creditCard))) {
            unset($this->CreditCard);
        } else {
            $this->CreditCard = $creditCard;
        }
        return $this;
    }
    /**
     * Get CurrencyId value
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->CurrencyId;
    }
    /**
     * Set CurrencyId value
     * @param string $currencyId
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        $this->CurrencyId = $currencyId;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MethodId value
     * @return string|null
     */
    public function getMethodId()
    {
        return $this->MethodId;
    }
    /**
     * Set MethodId value
     * @param string $methodId
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setMethodId($methodId = null)
    {
        // validation for constraint: string
        if (!is_null($methodId) && !is_string($methodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodId, true), gettype($methodId)), __LINE__);
        }
        $this->MethodId = $methodId;
        return $this;
    }
    /**
     * Get ReceivedPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\CreateFromRequestPaymentReceivedPayment|null
     */
    public function getReceivedPayment()
    {
        return isset($this->ReceivedPayment) ? $this->ReceivedPayment : null;
    }
    /**
     * Set ReceivedPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\CreateFromRequestPaymentReceivedPayment $receivedPayment
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setReceivedPayment(\Cegid\StructType\CreateFromRequestPaymentReceivedPayment $receivedPayment = null)
    {
        if (is_null($receivedPayment) || (is_array($receivedPayment) && empty($receivedPayment))) {
            unset($this->ReceivedPayment);
        } else {
            $this->ReceivedPayment = $receivedPayment;
        }
        return $this;
    }
    /**
     * Get VoucherId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherId()
    {
        return isset($this->VoucherId) ? $this->VoucherId : null;
    }
    /**
     * Set VoucherId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherId
     * @return \Cegid\StructType\CreateFromRequestPayment
     */
    public function setVoucherId($voucherId = null)
    {
        // validation for constraint: string
        if (!is_null($voucherId) && !is_string($voucherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherId, true), gettype($voucherId)), __LINE__);
        }
        if (is_null($voucherId) || (is_array($voucherId) && empty($voucherId))) {
            unset($this->VoucherId);
        } else {
            $this->VoucherId = $voucherId;
        }
        return $this;
    }
}
