<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFromRequestHeaderOriginalDocumentIdentifierReference
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateFromRequestHeaderOriginalDocumentIdentifierReference
 * @subpackage Structs
 */
class CreateFromRequestHeaderOriginalDocumentIdentifierReference extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomerId;
    /**
     * The InternalReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $InternalReference;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for
     * CreateFromRequestHeaderOriginalDocumentIdentifierReference
     * @uses CreateFromRequestHeaderOriginalDocumentIdentifierReference::setCustomerId()
     * @uses CreateFromRequestHeaderOriginalDocumentIdentifierReference::setInternalReference()
     * @uses CreateFromRequestHeaderOriginalDocumentIdentifierReference::setType()
     * @param string $customerId
     * @param string $internalReference
     * @param string $type
     */
    public function __construct($customerId = null, $internalReference = null, $type = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setInternalReference($internalReference)
            ->setType($type);
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifierReference
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get InternalReference value
     * @return string|null
     */
    public function getInternalReference()
    {
        return $this->InternalReference;
    }
    /**
     * Set InternalReference value
     * @param string $internalReference
     * @return \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifierReference
     */
    public function setInternalReference($internalReference = null)
    {
        // validation for constraint: string
        if (!is_null($internalReference) && !is_string($internalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalReference, true), gettype($internalReference)), __LINE__);
        }
        $this->InternalReference = $internalReference;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeOriginTransfo::valueIsValid()
     * @uses \Cegid\EnumType\CustomerOrderDocumentTypeOriginTransfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Cegid\StructType\CreateFromRequestHeaderOriginalDocumentIdentifierReference
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\CustomerOrderDocumentTypeOriginTransfo::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\CustomerOrderDocumentTypeOriginTransfo', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Cegid\EnumType\CustomerOrderDocumentTypeOriginTransfo::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
