<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressIndividual StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressIndividual
 * @subpackage Structs
 */
class AddressIndividual extends AbstractStructBase
{
    /**
     * The CivilityId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CivilityId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for AddressIndividual
     * @uses AddressIndividual::setCivilityId()
     * @uses AddressIndividual::setFirstName()
     * @uses AddressIndividual::setLastName()
     * @param string $civilityId
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct($civilityId = null, $firstName = null, $lastName = null)
    {
        $this
            ->setCivilityId($civilityId)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get CivilityId value
     * @return string|null
     */
    public function getCivilityId()
    {
        return $this->CivilityId;
    }
    /**
     * Set CivilityId value
     * @param string $civilityId
     * @return \Cegid\StructType\AddressIndividual
     */
    public function setCivilityId($civilityId = null)
    {
        // validation for constraint: string
        if (!is_null($civilityId) && !is_string($civilityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($civilityId, true), gettype($civilityId)), __LINE__);
        }
        $this->CivilityId = $civilityId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \Cegid\StructType\AddressIndividual
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \Cegid\StructType\AddressIndividual
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
}
