<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Update
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\Update $parameters
     * @return \Cegid\StructType\UpdateResponse|bool
     */
    public function Update(\Cegid\StructType\Update $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\UpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
