<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Replace ServiceType
 * @subpackage Services
 */
class Replace extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Replace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\Replace $parameters
     * @return \Cegid\StructType\ReplaceResponse|bool
     */
    public function Replace(\Cegid\StructType\Replace $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Replace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\ReplaceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
