<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refuse ServiceType
 * @subpackage Services
 */
class Refuse extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Refuse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\Refuse $parameters
     * @return \Cegid\StructType\RefuseResponse|bool
     */
    public function Refuse(\Cegid\StructType\Refuse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Refuse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\RefuseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
