<?php

namespace Cegid\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hello ServiceType
 * @subpackage Services
 */
class Hello extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HelloWorld
     * Meta information extracted from the WSDL
     * - documentation: Méthode HelloWorld pour valider l'accès au Web Service depuis tout client HTTP très léger via Javascript par exemple | Texte à passer pour tester la consommation. | Renvoie le texte saisi en entrée, concaténé de la phrase
     * 'Hello You'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Cegid\StructType\HelloWorld $parameters
     * @return \Cegid\StructType\HelloWorldResponse|bool
     */
    public function HelloWorld(\Cegid\StructType\HelloWorld $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HelloWorld($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Cegid\StructType\HelloWorldResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
