<?php

namespace Cegid\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFieldsType ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFieldsType
 * @subpackage Arrays
 */
class ArrayOfFieldsType extends AbstractStructArrayBase
{
    /**
     * The FieldsType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FieldsType;
    /**
     * Constructor method for ArrayOfFieldsType
     * @uses ArrayOfFieldsType::setFieldsType()
     * @param string[] $fieldsType
     */
    public function __construct(array $fieldsType = array())
    {
        $this
            ->setFieldsType($fieldsType);
    }
    /**
     * Get FieldsType value
     * @return string[]|null
     */
    public function getFieldsType()
    {
        return $this->FieldsType;
    }
    /**
     * This method is responsible for validating the values passed to the setFieldsType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFieldsType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldsTypeForArrayConstraintsFromSetFieldsType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFieldsTypeFieldsTypeItem) {
            // validation for constraint: enumeration
            if (!\Cegid\EnumType\FieldsType::valueIsValid($arrayOfFieldsTypeFieldsTypeItem)) {
                $invalidValues[] = is_object($arrayOfFieldsTypeFieldsTypeItem) ? get_class($arrayOfFieldsTypeFieldsTypeItem) : sprintf('%s(%s)', gettype($arrayOfFieldsTypeFieldsTypeItem), var_export($arrayOfFieldsTypeFieldsTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\FieldsType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \Cegid\EnumType\FieldsType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FieldsType value
     * @uses \Cegid\EnumType\FieldsType::valueIsValid()
     * @uses \Cegid\EnumType\FieldsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $fieldsType
     * @return \Cegid\ArrayType\ArrayOfFieldsType
     */
    public function setFieldsType(array $fieldsType = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldsTypeArrayErrorMessage = self::validateFieldsTypeForArrayConstraintsFromSetFieldsType($fieldsType))) {
            throw new \InvalidArgumentException($fieldsTypeArrayErrorMessage, __LINE__);
        }
        $this->FieldsType = $fieldsType;
        return $this;
    }
    /**
     * Add item to FieldsType value
     * @uses \Cegid\EnumType\FieldsType::valueIsValid()
     * @uses \Cegid\EnumType\FieldsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Cegid\ArrayType\ArrayOfFieldsType
     */
    public function addToFieldsType($item)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\FieldsType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\FieldsType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Cegid\EnumType\FieldsType::getValidValues())), __LINE__);
        }
        $this->FieldsType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \Cegid\EnumType\FieldsType::valueIsValid()
     * @param string $item
     * @return \Cegid\ArrayType\ArrayOfFieldsType
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\Cegid\EnumType\FieldsType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cegid\EnumType\FieldsType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Cegid\EnumType\FieldsType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FieldsType
     */
    public function getAttributeName()
    {
        return 'FieldsType';
    }
}
