<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Cegid\ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \Cegid\ServiceType\Hello($options);
/**
 * Sample call for HelloWorld operation/method
 */
if ($hello->HelloWorld(new \Cegid\StructType\HelloWorld()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \Cegid\ServiceType\Close($options);
/**
 * Sample call for Close operation/method
 */
if ($close->Close(new \Cegid\StructType\Close()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \Cegid\ServiceType\Create($options);
/**
 * Sample call for Create operation/method
 */
if ($create->Create(new \Cegid\StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateFrom operation/method
 */
if ($create->CreateFrom(new \Cegid\StructType\CreateFrom()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateFrom2 operation/method
 */
if ($create->CreateFrom2(new \Cegid\StructType\CreateFrom2()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Cegid\ServiceType\Get($options);
/**
 * Sample call for GetDetail operation/method
 */
if ($get->GetDetail(new \Cegid\StructType\GetDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetListDetail operation/method
 */
if ($get->GetListDetail(new \Cegid\StructType\GetListDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Refuse ServiceType
 */
$refuse = new \Cegid\ServiceType\Refuse($options);
/**
 * Sample call for Refuse operation/method
 */
if ($refuse->Refuse(new \Cegid\StructType\Refuse()) !== false) {
    print_r($refuse->getResult());
} else {
    print_r($refuse->getLastError());
}
/**
 * Samples for Replace ServiceType
 */
$replace = new \Cegid\ServiceType\Replace($options);
/**
 * Sample call for Replace operation/method
 */
if ($replace->Replace(new \Cegid\StructType\Replace()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \Cegid\ServiceType\Update($options);
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \Cegid\StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
