<?php

namespace Cegid\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRequestHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateRequestHeader
 * @subpackage Structs
 */
class UpdateRequestHeader extends AbstractStructBase
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Employees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\UpdateRequestHeaderEmployeeCollection
     */
    public $Employees;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\UpdateRequestHeaderReferences
     */
    public $References;
    /**
     * The UserDefined
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\StructType\UpdateRequestHeaderUserDefined
     */
    public $UserDefined;
    /**
     * The UserFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Cegid\ArrayType\ArrayOfUserFieldForPost
     */
    public $UserFields;
    /**
     * Constructor method for UpdateRequestHeader
     * @uses UpdateRequestHeader::setDeliveryDate()
     * @uses UpdateRequestHeader::setEmployees()
     * @uses UpdateRequestHeader::setExpiryDate()
     * @uses UpdateRequestHeader::setReferences()
     * @uses UpdateRequestHeader::setUserDefined()
     * @uses UpdateRequestHeader::setUserFields()
     * @param string $deliveryDate
     * @param \Cegid\StructType\UpdateRequestHeaderEmployeeCollection $employees
     * @param string $expiryDate
     * @param \Cegid\StructType\UpdateRequestHeaderReferences $references
     * @param \Cegid\StructType\UpdateRequestHeaderUserDefined $userDefined
     * @param \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields
     */
    public function __construct($deliveryDate = null, \Cegid\StructType\UpdateRequestHeaderEmployeeCollection $employees = null, $expiryDate = null, \Cegid\StructType\UpdateRequestHeaderReferences $references = null, \Cegid\StructType\UpdateRequestHeaderUserDefined $userDefined = null, \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setEmployees($employees)
            ->setExpiryDate($expiryDate)
            ->setReferences($references)
            ->setUserDefined($userDefined)
            ->setUserFields($userFields);
    }
    /**
     * Get DeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->DeliveryDate) ? $this->DeliveryDate : null;
    }
    /**
     * Set DeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \Cegid\StructType\UpdateRequestHeader
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->DeliveryDate);
        } else {
            $this->DeliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get Employees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\UpdateRequestHeaderEmployeeCollection|null
     */
    public function getEmployees()
    {
        return isset($this->Employees) ? $this->Employees : null;
    }
    /**
     * Set Employees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\UpdateRequestHeaderEmployeeCollection $employees
     * @return \Cegid\StructType\UpdateRequestHeader
     */
    public function setEmployees(\Cegid\StructType\UpdateRequestHeaderEmployeeCollection $employees = null)
    {
        if (is_null($employees) || (is_array($employees) && empty($employees))) {
            unset($this->Employees);
        } else {
            $this->Employees = $employees;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \Cegid\StructType\UpdateRequestHeader
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get References value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\UpdateRequestHeaderReferences|null
     */
    public function getReferences()
    {
        return isset($this->References) ? $this->References : null;
    }
    /**
     * Set References value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\UpdateRequestHeaderReferences $references
     * @return \Cegid\StructType\UpdateRequestHeader
     */
    public function setReferences(\Cegid\StructType\UpdateRequestHeaderReferences $references = null)
    {
        if (is_null($references) || (is_array($references) && empty($references))) {
            unset($this->References);
        } else {
            $this->References = $references;
        }
        return $this;
    }
    /**
     * Get UserDefined value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\StructType\UpdateRequestHeaderUserDefined|null
     */
    public function getUserDefined()
    {
        return isset($this->UserDefined) ? $this->UserDefined : null;
    }
    /**
     * Set UserDefined value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\StructType\UpdateRequestHeaderUserDefined $userDefined
     * @return \Cegid\StructType\UpdateRequestHeader
     */
    public function setUserDefined(\Cegid\StructType\UpdateRequestHeaderUserDefined $userDefined = null)
    {
        if (is_null($userDefined) || (is_array($userDefined) && empty($userDefined))) {
            unset($this->UserDefined);
        } else {
            $this->UserDefined = $userDefined;
        }
        return $this;
    }
    /**
     * Get UserFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Cegid\ArrayType\ArrayOfUserFieldForPost|null
     */
    public function getUserFields()
    {
        return isset($this->UserFields) ? $this->UserFields : null;
    }
    /**
     * Set UserFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Cegid\ArrayType\ArrayOfUserFieldForPost $userFields
     * @return \Cegid\StructType\UpdateRequestHeader
     */
    public function setUserFields(\Cegid\ArrayType\ArrayOfUserFieldForPost $userFields = null)
    {
        if (is_null($userFields) || (is_array($userFields) && empty($userFields))) {
            unset($this->UserFields);
        } else {
            $this->UserFields = $userFields;
        }
        return $this;
    }
}
